/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizePage;
import org.eclipse.team.internal.ui.synchronize.ForwardingChangesSection;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SyncInfoSetChangesSection
extends ForwardingChangesSection {
    private boolean showingError;
    private final SynchronizePageActionGroup changedListener = new SynchronizePageActionGroup(){

        @Override
        public void modelChanged(ISynchronizeModelElement root) {
            SyncInfoSetChangesSection.this.calculateDescription();
        }
    };
    private final ISyncInfoSetChangeListener subscriberListener = new ISyncInfoSetChangeListener(){

        public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        }

        public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
            SyncInfoSetChangesSection.this.calculateDescription();
        }

        public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
        }
    };
    private final ISyncInfoSetChangeListener outputSetListener = new ISyncInfoSetChangeListener(){

        public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
            SyncInfoSetChangesSection.this.calculateDescription();
        }

        public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        }

        public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
            SyncInfoSetChangesSection.this.calculateDescription();
        }
    };

    public SyncInfoSetChangesSection(Composite parent, AbstractSynchronizePage page, ISynchronizePageConfiguration configuration) {
        super(parent, page, configuration);
    }

    @Override
    protected void initializeChangesViewer() {
        super.initializeChangesViewer();
        this.getConfiguration().addActionContribution(this.changedListener);
        this.getParticipantSyncInfoSet().addSyncSetChangedListener(this.subscriberListener);
        this.getVisibleSyncInfoSet().addSyncSetChangedListener(this.outputSetListener);
    }

    @Override
    protected void calculateDescription() {
        SyncInfoTree syncInfoTree = this.getVisibleSyncInfoSet();
        if (syncInfoTree.getErrors().length > 0) {
            if (!this.showingError) {
                TeamUIPlugin.getStandardDisplay().asyncExec(() -> {
                    this.updatePage(this.getErrorComposite((Composite)this.getContainer()));
                    this.showingError = true;
                });
            }
            return;
        }
        this.showingError = false;
        super.calculateDescription();
    }

    @Override
    protected long getChangesInMode(int candidateMode) {
        SyncInfoSet participantSet = this.getParticipantSyncInfoSet();
        return switch (candidateMode) {
            case 2 -> participantSet.countFor(4, 12);
            case 1 -> participantSet.countFor(8, 12);
            case 4 -> participantSet.countFor(8, 12) + participantSet.countFor(4, 12);
            default -> 0L;
        };
    }

    @Override
    protected int getCandidateMode() {
        long incomingChanges;
        SyncInfoSet participantSet = this.getParticipantSyncInfoSet();
        SynchronizePageConfiguration configuration = (SynchronizePageConfiguration)this.getConfiguration();
        long outgoingChanges = participantSet.countFor(4, 12);
        if (outgoingChanges > 0L) {
            if (configuration.isModeSupported(2)) {
                return 2;
            }
            if (configuration.isModeSupported(4)) {
                return 4;
            }
        }
        if ((incomingChanges = participantSet.countFor(8, 12)) > 0L) {
            if (configuration.isModeSupported(1)) {
                return 1;
            }
            if (configuration.isModeSupported(4)) {
                return 4;
            }
        }
        return configuration.getMode();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getConfiguration().removeActionContribution(this.changedListener);
        this.getParticipantSyncInfoSet().removeSyncSetChangedListener(this.subscriberListener);
        this.getVisibleSyncInfoSet().removeSyncSetChangedListener(this.outputSetListener);
    }

    private Composite getErrorComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getListBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        Hyperlink link = new Hyperlink(composite, 64);
        link.setText(TeamUIMessages.ChangesSection_8);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SyncInfoSetChangesSection.this.showErrors();
            }
        });
        link.setBackground(this.getListBackgroundColor());
        link.setUnderlined(true);
        link = new Hyperlink(composite, 64);
        link.setText(TeamUIMessages.ChangesSection_9);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SyncInfoSetChangesSection.this.getPage().reset();
            }
        });
        link.setBackground(this.getListBackgroundColor());
        link.setUnderlined(true);
        this.createDescriptionLabel(composite, NLS.bind((String)TeamUIMessages.ChangesSection_10, (Object[])new String[]{Utils.shortenText(100, this.getConfiguration().getParticipant().getName())}));
        return composite;
    }

    void showErrors() {
        ITeamStatus[] status = this.getVisibleSyncInfoSet().getErrors();
        String title = TeamUIMessages.ChangesSection_11;
        if (status.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)status[0].getMessage(), (IStatus)status[0]);
        } else {
            MultiStatus multi = new MultiStatus("org.eclipse.team.ui", 0, (IStatus[])status, TeamUIMessages.ChangesSection_12, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)multi);
        }
    }

    @Override
    protected int getChangesCount() {
        return this.getParticipantSyncInfoSet().size();
    }

    @Override
    protected long getVisibleChangesCount() {
        return this.getVisibleSyncInfoSet().size();
    }

    private SyncInfoTree getVisibleSyncInfoSet() {
        return (SyncInfoTree)this.getConfiguration().getProperty("org.eclipse.team.ui.P_SYNC_INFO_SET");
    }

    private SyncInfoSet getParticipantSyncInfoSet() {
        return (SyncInfoSet)this.getConfiguration().getProperty("org.eclipse.team.ui.P_WORKING_SET_SYNC_INFO_SET");
    }
}

