/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineLaunchExtension;
import org.eclipse.ease.lang.python.PythonCodeFactory;
import org.eclipse.ease.lang.python.debugger.ResourceHelper;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.modules.ModuleCategoryDefinition;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.tools.StringTools;

public class Pep302ModuleImporter
implements IScriptEngineLaunchExtension {
    public static boolean isModulePath(String candidate) {
        if ("eclipse".equals(candidate = candidate.toLowerCase())) {
            return true;
        }
        if (candidate.startsWith("eclipse.")) {
            candidate = candidate.substring("eclipse".length());
            candidate = candidate.replace('.', '/').replaceAll("[^A-Za-z0-9/]", "_");
            IScriptService scriptService = ScriptService.getService();
            for (ModuleCategoryDefinition category : scriptService.getAvailableModuleCategories().values()) {
                if (!category.getFullName().toLowerCase().replaceAll("[^A-Za-z0-9/]", "_").equals(candidate)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isModule(String candidate) {
        return Pep302ModuleImporter.getModuleDefinition(candidate) != null;
    }

    private static ModuleDefinition getModuleDefinition(String candidate) {
        if ((candidate = candidate.toLowerCase()).startsWith("eclipse")) {
            candidate = candidate.substring("eclipse".length());
        }
        candidate = candidate.replace('.', '/').replaceAll("[^A-Za-z0-9/]", "_");
        IScriptService scriptService = ScriptService.getService();
        for (ModuleDefinition definition : scriptService.getAvailableModules()) {
            if (!definition.getPath().toString().toLowerCase().replaceAll("[^A-Za-z0-9/]", "_").equals(candidate)) continue;
            return definition;
        }
        return null;
    }

    public static String getCode(String moduleName, EnvironmentModule enviromentModule) {
        ModuleDefinition definition = Pep302ModuleImporter.getModuleDefinition(moduleName);
        if (definition != null) {
            Object instance = enviromentModule.getModuleInstance(definition);
            ICodeFactory factory = ScriptService.getCodeFactory((IScriptEngine)enviromentModule.getScriptEngine());
            if (factory instanceof PythonCodeFactory) {
                String identifier = factory.getSaveVariableName(EnvironmentModule.getWrappedVariableName((Object)instance));
                enviromentModule.getScriptEngine().setVariable(identifier, instance);
                return ((PythonCodeFactory)factory).createPep302WrapperCode(enviromentModule, instance, identifier);
            }
            throw new RuntimeException("No code factory found supporting Pep302 imports");
        }
        throw new RuntimeException("Module <" + moduleName + "> could not be found");
    }

    public void createEngine(IScriptEngine engine) {
        try {
            InputStream resourceStream = ResourceHelper.getResourceStream("org.eclipse.ease.lang.python", "/pysrc/pep302.py");
            String code = StringTools.toString((InputStream)resourceStream);
            resourceStream.close();
            engine.execute((Object)code);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

