/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.virtual.resources.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.IVirtualMachineEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.IVirtualEnvironmentModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class QemuKvmEventHandler
implements IVirtualMachineEventHandler {
    private Map<IKernelAnalysisEventLayout, Set<String>> fRequiredEvents = new HashMap<IKernelAnalysisEventLayout, Set<String>>();

    @Override
    public Set<String> getRequiredEvents(IKernelAnalysisEventLayout layout) {
        Set<String> events = this.fRequiredEvents.get(layout);
        if (events == null) {
            events = new HashSet<String>();
            events.addAll(layout.eventsKVMEntry());
            events.addAll(layout.eventsKVMExit());
            this.fRequiredEvents.put(layout, events);
        }
        return events;
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event, IVirtualEnvironmentModel virtEnv, IKernelAnalysisEventLayout layout) {
        String eventName = event.getName();
        long ts = event.getTimestamp().toNanos();
        if (layout.eventsKVMEntry().contains(eventName)) {
            QemuKvmEventHandler.handleKvmEvent(ss, ts, event, virtEnv, i -> i & 0xFFFFFF7F);
        } else if (layout.eventsKVMExit().contains(eventName)) {
            QemuKvmEventHandler.handleKvmEvent(ss, ts, event, virtEnv, i -> i | 0x80);
        }
    }

    private static void handleKvmEvent(ITmfStateSystemBuilder ss, long ts, ITmfEvent event, IVirtualEnvironmentModel virtEnv, Function<Integer, Integer> fctNewVal) {
        HostThread ht = IVirtualMachineEventHandler.getCurrentHostThread(event, ts);
        if (ht == null) {
            return;
        }
        VirtualCPU vcpu = virtEnv.getVirtualCpu(event, ht);
        if (vcpu == null) {
            return;
        }
        VirtualMachine vm = vcpu.getVm();
        int curStatusQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Virtual Machines", vm.getHostId(), vcpu.getCpuId().toString(), "Status"});
        int prevStatus = Math.max(0, ss.queryOngoingState(curStatusQuark).unboxInt());
        int value = Objects.requireNonNull(fctNewVal.apply(prevStatus));
        ss.modifyAttribute(ts, (Object)value, curStatusQuark);
    }
}

