/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.executioncomparison.core;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackSymbol;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.AggregatedCallSite;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.CallGraph;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider2;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.InstrumentedCallStackAnalysis;
import org.eclipse.tracecompass.analysis.profiling.core.tree.ITree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTreeSet;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.WeightedTreeUtils;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.core.DifferentialCallGraphProvider;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.core.TmfComparisonFilteringUpdatedSignal;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCalledFunction;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class DifferentialSeqCallGraphAnalysis
extends TmfAbstractAnalysisModule {
    public static final String ID = "org.eclipse.tracecompass.incubator.executioncomparison.diffcallgraph";
    private static final Logger LOGGER = TraceCompassLog.getLogger(DifferentialSeqCallGraphAnalysis.class);
    private static final String MERGE = "Merge";
    private static Map<String, String> fCallStackAnalysisMap = new HashMap<String, String>();
    private static Map<String, ICallGraphProvider2> fTraceCallGraphRegistry = new HashMap<String, ICallGraphProvider2>();
    private @Nullable DifferentialCallGraphProvider fDifferentialCallGraphProvider;
    private ITmfTimestamp fStartA = TmfTimestamp.BIG_BANG;
    private ITmfTimestamp fEndA = TmfTimestamp.BIG_CRUNCH;
    private ITmfTimestamp fStartB = TmfTimestamp.BIG_BANG;
    private ITmfTimestamp fEndB = TmfTimestamp.BIG_CRUNCH;
    private String fStatistic = "";
    private List<String> fTraceListA = new ArrayList<String>();
    private List<String> fTraceListB = new ArrayList<String>();
    private @Nullable Job fDiffJob = null;

    public DifferentialSeqCallGraphAnalysis() {
        fCallStackAnalysisMap.put("org.eclipse.tracecompass.incubator.traceevent.core.trace", "org.eclipse.tracecompass.incubator.traceevent.analysis.callstack");
        fCallStackAnalysisMap.put("org.eclipse.linuxtools.lttng2.ust.tracetype", "org.eclipse.tracecompass.lttng2.ust.core.analysis.callstack");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public DifferentialCallGraphProvider refreshDiffCG(@Nullable IProgressMonitor monitor) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog sl = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.CONFIG, "DifferentialSequenceCGA::refresh()", new Object[0]);){
            ArrayList<AggregatedCalledFunction> originalTree = new ArrayList<AggregatedCalledFunction>();
            ArrayList<AggregatedCalledFunction> diffTree = new ArrayList<AggregatedCalledFunction>();
            WeightedTreeSet<ICallStackSymbol, Object> callGraphA = this.mergeCallGraph(this.fStartA, this.fEndA, this.getTraceListA());
            @NonNull Collection processes = callGraphA.getTreesForNamed(new String[]{MERGE});
            for (Object process : processes) {
                originalTree.add((AggregatedCalledFunction)process);
            }
            WeightedTreeSet<ICallStackSymbol, Object> callGraphB = this.mergeCallGraph(this.fStartB, this.fEndB, this.getTraceListB());
            processes = callGraphB.getTreesForNamed(new String[]{MERGE});
            for (Object process : processes) {
                diffTree.add((AggregatedCalledFunction)process);
            }
            Collection trees = WeightedTreeUtils.diffTrees(originalTree, diffTree, (String)this.fStatistic);
            IWeightedTreeProvider instrumentedCallStackAnalysis = (IWeightedTreeProvider)Iterables.get(fTraceCallGraphRegistry.values(), (int)0);
            this.fDifferentialCallGraphProvider = new DifferentialCallGraphProvider((IWeightedTreeProvider<ICallStackSymbol, ICallStackElement, AggregatedCallSite>)instrumentedCallStackAnalysis, trees);
            return this.fDifferentialCallGraphProvider;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public WeightedTreeSet<ICallStackSymbol, Object> mergeCallGraph(ITmfTimestamp start, ITmfTimestamp end, List<String> traceList) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceCompassLogUtils.ScopeLog sl = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "DifferentialSequenceCGA::MergeCallGraph", new Object[0]);){
            WeightedTreeSet newTreeSet = new WeightedTreeSet();
            String mainGroup = MERGE;
            List<CallGraph> cGList = DifferentialSeqCallGraphAnalysis.addToCallGraph(start, end, traceList);
            for (CallGraph callGraph : cGList) {
                Collection<ICallStackElement> elements = DifferentialSeqCallGraphAnalysis.getLeafElements(callGraph);
                for (ICallStackElement element : elements) {
                    DifferentialSeqCallGraphAnalysis.recurseAddElementData(element, mainGroup, callGraph, (WeightedTreeSet<ICallStackSymbol, Object>)newTreeSet);
                }
            }
            return newTreeSet;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static List<CallGraph> addToCallGraph(ITmfTimestamp start, ITmfTimestamp end, List<String> traceList) {
        ArrayList<CallGraph> cGList = new ArrayList<CallGraph>();
        for (String traceName : traceList) {
            ITmfTrace trace;
            ICallGraphProvider2 instrumentedCallStackAnalysis = fTraceCallGraphRegistry.get(traceName);
            if (instrumentedCallStackAnalysis == null || (trace = DifferentialSeqCallGraphAnalysis.getTrace(traceName)) == null) continue;
            ITmfTimestamp traceStart = start;
            ITmfTimestamp traceEnd = end;
            if (traceStart.getValue() < trace.getStartTime().getValue()) {
                traceStart = trace.getStartTime();
            }
            if (traceEnd.getValue() > trace.getEndTime().getValue()) {
                traceEnd = trace.getEndTime();
            }
            cGList.add(instrumentedCallStackAnalysis.getCallGraph(traceStart, traceEnd));
        }
        return cGList;
    }

    public @Nullable DifferentialWeightedTreeProvider<?> getDifferentialTreeProvider(IProgressMonitor monitor) {
        if (fTraceCallGraphRegistry.isEmpty()) {
            ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
            Collection traceSet = TmfTraceManager.getTraceSet((ITmfTrace)trace);
            block0: for (ITmfTrace traceMember : traceSet) {
                Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)traceMember, InstrumentedCallStackAnalysis.class);
                for (InstrumentedCallStackAnalysis module : modules) {
                    if (!module.getId().equals(fCallStackAnalysisMap.get(traceMember.getTraceTypeId()))) continue;
                    InstrumentedCallStackAnalysis callGraphModule = module;
                    callGraphModule.schedule();
                    fTraceCallGraphRegistry.put(String.valueOf(traceMember.getName()), (ICallGraphProvider2)callGraphModule);
                    while (!callGraphModule.waitForCompletion()) {
                        if (!monitor.isCanceled()) continue;
                        callGraphModule.cancel();
                        return null;
                    }
                    continue block0;
                }
            }
        }
        this.refreshDiffCG(monitor);
        return this.fDifferentialCallGraphProvider;
    }

    private static Collection<ICallStackElement> getLeafElements(CallGraph weightedTree) {
        Collection elements = weightedTree.getElements();
        ArrayList<ICallStackElement> leafGroups = new ArrayList<ICallStackElement>();
        for (ICallStackElement group : elements) {
            leafGroups.addAll(DifferentialSeqCallGraphAnalysis.getLeafElement(group));
        }
        return leafGroups;
    }

    private static List<ICallStackElement> getLeafElement(ICallStackElement group) {
        if (group.isLeaf()) {
            return Collections.singletonList(group);
        }
        ArrayList<ICallStackElement> leafGroups = new ArrayList<ICallStackElement>();
        group.getChildrenElements().forEach(g -> {
            boolean bl = leafGroups.addAll(DifferentialSeqCallGraphAnalysis.getLeafElement(g));
        });
        return leafGroups;
    }

    private static void recurseAddElementData(ICallStackElement element, String group, CallGraph callGraph, WeightedTreeSet<ICallStackSymbol, Object> newTreeSet) {
        for (AggregatedCallSite tree : callGraph.getCallingContextTree(element)) {
            newTreeSet.addWeightedTree((Object)group, (WeightedTree)tree.copyOf());
        }
        ICallStackElement treeEl = element;
        Collection children = treeEl.getChildren();
        for (ITree child : children) {
            if (!(child instanceof ICallStackElement)) continue;
            DifferentialSeqCallGraphAnalysis.recurseAddElementData((ICallStackElement)child, group, callGraph, newTreeSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeAnalysis(IProgressMonitor monitor) {
        DifferentialSeqCallGraphAnalysis differentialSeqCallGraphAnalysis = this;
        synchronized (differentialSeqCallGraphAnalysis) {
            if (this.fDiffJob != null) {
                this.fDiffJob.cancel();
            }
            this.fDiffJob = new Job("Make differential Callgraph"){

                protected IStatus run(@Nullable IProgressMonitor progressMonitor) {
                    DifferentialSeqCallGraphAnalysis.this.refreshDiffCG(progressMonitor);
                    if (progressMonitor != null) {
                        progressMonitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fDiffJob.schedule();
        }
        return true;
    }

    public boolean waitForCompletion() {
        if (this.fDiffJob != null) {
            try {
                this.fDiffJob.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            return true;
        }
        return false;
    }

    protected void canceling() {
        if (this.fDiffJob != null) {
            this.fDiffJob.cancel();
        }
        super.cancel();
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfComparisonFilteringUpdatedSignal signal) {
        List<String> traceListB;
        this.fStartA = TmfTimestamp.BIG_BANG.equals(signal.getBeginTimeA()) ? this.fStartA : signal.getBeginTimeA();
        this.fEndA = TmfTimestamp.BIG_CRUNCH.equals(signal.getEndTimeA()) ? this.fEndA : signal.getEndTimeA();
        this.fStartB = TmfTimestamp.BIG_BANG.equals(signal.getBeginTimeB()) ? this.fStartB : signal.getBeginTimeB();
        this.fEndB = TmfTimestamp.BIG_CRUNCH.equals(signal.getEndTimeB()) ? this.fEndB : signal.getEndTimeB();
        String statistic = signal.getStatistic();
        this.fStatistic = statistic == null ? this.fStatistic : statistic;
        List<String> traceListA = signal.getTraceListA();
        if (traceListA != null) {
            DifferentialSeqCallGraphAnalysis.synchronizedListAdd(traceListA, this.fTraceListA);
        }
        if ((traceListB = signal.getTraceListB()) != null) {
            DifferentialSeqCallGraphAnalysis.synchronizedListAdd(traceListB, this.fTraceListB);
        }
        if (!fTraceCallGraphRegistry.isEmpty()) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (TraceCompassLogUtils.ScopeLog sl = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "MakeDiffCallGraph", new Object[0]);){
                NullProgressMonitor monitor = new NullProgressMonitor();
                this.executeAnalysis((IProgressMonitor)monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> synchronizedListAdd(List<String> traceList, List<String> fTraceList) {
        List<String> synchronizedList;
        List<String> list = synchronizedList = Collections.synchronizedList(fTraceList);
        synchronized (list) {
            synchronizedList.clear();
            for (String name : traceList) {
                synchronizedList.add(name);
            }
        }
        return synchronizedList;
    }

    public boolean canExecute(ITmfTrace trace) {
        if (trace instanceof TmfExperiment) {
            for (ITmfTrace individualTrace : ((TmfExperiment)trace).getTraces()) {
                Iterable modules = individualTrace.getAnalysisModules();
                for (IAnalysisModule module : modules) {
                    if (!fCallStackAnalysisMap.containsValue(module.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.cancel();
            DifferentialSeqCallGraphAnalysis differentialSeqCallGraphAnalysis = this;
            synchronized (differentialSeqCallGraphAnalysis) {
                if (this.fDiffJob != null) {
                    this.fDiffJob.cancel();
                    this.fDiffJob = null;
                }
                fTraceCallGraphRegistry.clear();
                this.fTraceListA.clear();
                this.fTraceListB.clear();
                this.fDifferentialCallGraphProvider = null;
                this.fStartA = TmfTimestamp.BIG_BANG;
                this.fEndA = TmfTimestamp.BIG_CRUNCH;
                this.fStartB = TmfTimestamp.BIG_BANG;
                this.fEndB = TmfTimestamp.BIG_CRUNCH;
            }
            TmfSignalManager.deregister((Object)((Object)this));
        }
        finally {
            super.dispose();
        }
    }

    private static @Nullable ITmfTrace getTrace(String traceName) {
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        Collection traceSet = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        for (ITmfTrace traceMember : traceSet) {
            if (!traceMember.getName().equals(traceName)) continue;
            return traceMember;
        }
        return null;
    }

    private List<String> getTraceListA() {
        return new ArrayList<String>(this.fTraceListA);
    }

    private List<String> getTraceListB() {
        return new ArrayList<String>(this.fTraceListB);
    }
}

