/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.actions.FindDeclarationsAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class FindDeclarationsInHierarchyAction
extends FindDeclarationsAction {
    public FindDeclarationsInHierarchyAction(IWorkbenchSite site) {
        super(site);
    }

    public FindDeclarationsInHierarchyAction(JavaEditor editor) {
        super(editor);
    }

    @Override
    Class[] getValidTypes() {
        return new Class[]{IField.class, IFunction.class, ILocalVariable.class};
    }

    @Override
    void init() {
        this.setText(SearchMessages.Search_FindHierarchyDeclarationsAction_label);
        this.setToolTipText(SearchMessages.Search_FindHierarchyDeclarationsAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_DECL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_declarations_in_hierarchy_action");
    }

    @Override
    QuerySpecification createQuery(IJavaScriptElement element) throws JavaScriptModelException, InterruptedException {
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        IType type = this.getType(element);
        if (type == null) {
            return super.createQuery(element);
        }
        IJavaScriptSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
        String description = factory.getHierarchyScopeDescription(type);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

