/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.queues;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.AbstractRosStateProvider;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.queues.RosQueuesAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RosQueuesStateProvider
extends AbstractRosStateProvider {
    private static final int VERSION_NUMBER = 0;

    public RosQueuesStateProvider(ITmfTrace trace) {
        super(trace, RosQueuesAnalysis.getFullAnalysisId());
    }

    @Override
    public int getVersion() {
        return 0;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void eventHandle(@NonNull ITmfEvent event) {
        super.eventHandle(event);
        if (!RosQueuesStateProvider.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        long timestamp = event.getTimestamp().toNanos();
        try {
            if (RosQueuesStateProvider.isEvent(event, this.fLayout.eventSubCallbackAdded())) {
                String nodeName = this.getNodeName(event);
                String topicName = (String)RosQueuesStateProvider.getField(event, this.fLayout.fieldSourceName());
                int subsListQuark = ss.getQuarkAbsoluteAndAdd(new String[]{nodeName, "Subscribers"});
                try {
                    StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ss, (long)timestamp, (int)subsListQuark, (int)1);
                }
                catch (StateValueTypeException stateValueTypeException) {
                    // empty catch block
                }
                int subQuark = ss.getQuarkRelativeAndAdd(subsListQuark, new String[]{topicName});
                ss.modifyAttribute(timestamp, (Object)topicName, subQuark);
                ss.getQuarkRelativeAndAdd(subsListQuark, new String[]{"callbacks"});
                ss.getQuarkRelativeAndAdd(subQuark, new String[]{"queue"});
                ss.getQuarkRelativeAndAdd(subQuark, new String[]{"message processing"});
                ss.getQuarkRelativeAndAdd(subQuark, new String[]{"drops"});
                return;
            }
            if (RosQueuesStateProvider.isEvent(event, this.fLayout.eventPubMsgQueued())) {
                int pubQueueQuark;
                boolean isLatchedMsg;
                String nodeName = this.getNodeName(event);
                String topicName = (String)RosQueuesStateProvider.getField(event, this.fLayout.fieldTopic());
                Long buffRef = (Long)RosQueuesStateProvider.getField(event, this.fLayout.fieldBufferRef());
                Long isLatchedMsgInt = (Long)RosQueuesStateProvider.getField(event, this.fLayout.fieldIsLatchedMsg());
                boolean bl = isLatchedMsg = isLatchedMsgInt == 1L;
                if (isLatchedMsg) {
                    pubQueueQuark = ss.getQuarkAbsoluteAndAdd(new String[]{nodeName, "Publishers", topicName, "queue"});
                    StateSystemUtils.queuePollAttribute((ITmfStateSystemBuilder)ss, (long)timestamp, (int)pubQueueQuark);
                }
                pubQueueQuark = ss.getQuarkAbsoluteAndAdd(new String[]{nodeName, "Publishers", topicName, "queue"});
                StateSystemUtils.queueOfferAttribute((ITmfStateSystemBuilder)ss, (long)timestamp, (Object)Objects.requireNonNull(buffRef), (int)pubQueueQuark);
                return;
            }
            boolean isSubLinkDrop = false;
            isSubLinkDrop = RosQueuesStateProvider.isEvent(event, this.fLayout.eventSubLinkMsgDropped());
            if (isSubLinkDrop || RosQueuesStateProvider.isEvent(event, this.fLayout.eventSubLinkMsgWrite())) {
                String nodeName = this.getNodeName(event);
                Long msgRef = (Long)RosQueuesStateProvider.getField(event, this.fLayout.fieldMsgRef());
                String topicName = null;
                int nodePubsQuark = ss.getQuarkAbsolute(new String[]{nodeName, "Publishers"});
                @NonNull List pubTopics = ss.getSubAttributes(nodePubsQuark, false);
                for (Integer topicQuark : pubTopics) {
                    Integer queueQuark;
                    Object bufferRef;
                    @NonNull String topicQuarkName = ss.getAttributeName(topicQuark.intValue());
                    @NonNull List queueQuarks = ss.getSubAttributes(topicQuark.intValue(), false);
                    if (queueQuarks.isEmpty() || (bufferRef = StateSystemUtils.queuePeekAttribute((ITmfStateSystemBuilder)ss, (long)timestamp, (int)(queueQuark = (Integer)queueQuarks.get(0)))) == null || !msgRef.equals(bufferRef)) continue;
                    topicName = topicQuarkName;
                    break;
                }
                if (topicName == null) {
                    Activator.getInstance().logError("[" + nodeName + "] Could not find matching topic for subscriber_link_message_" + (isSubLinkDrop ? "dropped" : "write") + " with msgRef=" + RosQueuesStateProvider.formatLongDecToHex(msgRef) + "; there may be lost events");
                    return;
                }
                int topicQuark = ss.getQuarkAbsolute(new String[]{nodeName, "Publishers", topicName});
                int pubQueueQuark = ss.getQuarkRelativeAndAdd(topicQuark, new String[]{"queue"});
                StateSystemUtils.queuePollAttribute((ITmfStateSystemBuilder)ss, (long)timestamp, (int)pubQueueQuark);
                if (isSubLinkDrop) {
                    RosQueuesStateProvider.markDroppedMsg(ss, timestamp, topicQuark, msgRef);
                }
                return;
            }
            if (RosQueuesStateProvider.isEvent(event, this.fLayout.eventSubMsgQueued())) {
                String nodeName = this.getNodeName(event);
                String topicName = (String)RosQueuesStateProvider.getField(event, this.fLayout.fieldTopic());
                Long msgRef = (Long)RosQueuesStateProvider.getField(event, this.fLayout.fieldMsgRef());
                int subQueueQuark = ss.getQuarkAbsolute(new String[]{nodeName, "Subscribers", topicName, "queue"});
                StateSystemUtils.queueOfferAttribute((ITmfStateSystemBuilder)ss, (long)timestamp, (Object)Objects.requireNonNull(msgRef), (int)subQueueQuark);
                return;
            }
            if (RosQueuesStateProvider.isEvent(event, this.fLayout.eventSubMsgDropped())) {
                String nodeName = this.getNodeName(event);
                String topicName = (String)RosQueuesStateProvider.getField(event, this.fLayout.fieldTopic());
                Long msgRef = (Long)RosQueuesStateProvider.getField(event, this.fLayout.fieldMsgRef());
                int topicQuark = ss.getQuarkAbsolute(new String[]{nodeName, "Subscribers", topicName});
                RosQueuesStateProvider.markDroppedMsg(ss, timestamp, topicQuark, msgRef);
                int subQueueQuark = ss.getQuarkRelative(topicQuark, new String[]{"queue"});
                StateSystemUtils.queuePollAttribute((ITmfStateSystemBuilder)ss, (long)timestamp, (int)subQueueQuark);
                return;
            }
            if (RosQueuesStateProvider.isEvent(event, this.fLayout.eventCallbackStart())) {
                String nodeName = this.getNodeName(event);
                Long callbackRef = (Long)RosQueuesStateProvider.getField(event, this.fLayout.fieldCallbackRef());
                int subCallbacksQuark = ss.getQuarkAbsolute(new String[]{nodeName, "Subscribers", "callbacks"});
                ss.modifyAttribute(timestamp, (Object)callbackRef, subCallbacksQuark);
                return;
            }
            if (RosQueuesStateProvider.isEvent(event, this.fLayout.eventSubCallbackStart())) {
                String nodeName = this.getNodeName(event);
                String topicName = (String)RosQueuesStateProvider.getField(event, this.fLayout.fieldTopic());
                Long msgRef = (Long)RosQueuesStateProvider.getField(event, this.fLayout.fieldMsgRef());
                int subsListQuark = ss.getQuarkAbsolute(new String[]{nodeName, "Subscribers"});
                int subCallbackQuark = ss.getQuarkRelative(subsListQuark, new String[]{topicName, "message processing"});
                ss.modifyAttribute(timestamp, (Object)msgRef, subCallbackQuark);
                int subCallbacksQuark = ss.getQuarkRelative(subsListQuark, new String[]{"callbacks"});
                ss.modifyAttribute(timestamp, (Object)msgRef, subCallbacksQuark);
                int subQueueQuark = ss.getQuarkRelative(subsListQuark, new String[]{topicName, "queue"});
                StateSystemUtils.queuePollAttribute((ITmfStateSystemBuilder)ss, (long)timestamp, (int)subQueueQuark);
                return;
            }
            if (RosQueuesStateProvider.isEvent(event, this.fLayout.eventSubCallbackEnd())) {
                String nodeName = this.getNodeName(event);
                String topicName = (String)RosQueuesStateProvider.getField(event, this.fLayout.fieldTopic());
                int subsListQuark = ss.getQuarkAbsolute(new String[]{nodeName, "Subscribers"});
                int subCallbackQuark = ss.getQuarkRelative(subsListQuark, new String[]{topicName, "message processing"});
                ss.modifyAttribute(timestamp, null, subCallbackQuark);
                int subCallbacksQuark = ss.getQuarkRelative(subsListQuark, new String[]{"callbacks"});
                ss.modifyAttribute(timestamp, null, subCallbacksQuark);
                return;
            }
            if (RosQueuesStateProvider.isEvent(event, this.fLayout.eventCallbackEnd())) {
                String nodeName = this.getNodeName(event);
                Long callbackRef = (Long)RosQueuesStateProvider.getField(event, this.fLayout.fieldCallbackRef());
                int subCallbacksQuark = ss.getQuarkAbsolute(new String[]{nodeName, "Subscribers", "callbacks"});
                ss.updateOngoingState((Object)callbackRef, subCallbacksQuark);
                ss.modifyAttribute(timestamp, null, subCallbacksQuark);
                return;
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.getInstance().logError("Could not get queue quark; there may be missing events: ", (Throwable)e);
        }
        catch (StateSystemDisposedException e) {
            Activator.getInstance().logError("Error querying statesystem: ", (Throwable)e);
        }
    }

    private static void markDroppedMsg(ITmfStateSystemBuilder ss, long timestamp, int topicQuark, Long msgRef) throws StateSystemDisposedException {
        int queueQuark = ss.getQuarkRelativeAndAdd(topicQuark, new String[]{"queue", "1"});
        long droppedMsgStartTime = ss.querySingleState(timestamp - 1L, queueQuark).getStartTime();
        int dropsQuark = ss.getQuarkRelativeAndAdd(topicQuark, new String[]{"drops"});
        ss.modifyAttribute(droppedMsgStartTime, (Object)msgRef, dropsQuark);
        ss.modifyAttribute(timestamp, null, dropsQuark);
    }
}

