/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.wst.jsdt.internal.core.util.QualificationHelpers;

public class MethodPattern
extends JavaSearchPattern {
    protected static final char[][] REF_CATEGORIES = new char[][]{METHOD_REF};
    protected static final char[][] REF_AND_DECL_CATEGORIES = new char[][]{METHOD_REF, METHOD_DECL};
    protected static final char[][] DECL_CATEGORIES = new char[][]{METHOD_DECL};
    protected static final char[][] FUNCTION_REF_AND_DECL_CATEGORIES = new char[][]{METHOD_REF, FUNCTION_DECL, METHOD_DECL};
    protected static final char[][] FUNCTION_DECL_CATEGORIES = new char[][]{FUNCTION_DECL, METHOD_DECL};
    public char[] selector;
    public char[][] parameterQualifications;
    public char[][] parameterSimpleNames;
    public char[][] parameterNames;
    public char[] returnQualification;
    public char[] returnSimpleName;
    private char[][] declaringQualification;
    private char[][] declaringSimpleName;
    public int modifiers;
    protected boolean findDeclarations;
    protected boolean findReferences;
    protected boolean isFunction;

    MethodPattern(int matchRule, boolean isFunction) {
        super(128, matchRule);
        this.isFunction = isFunction;
    }

    public MethodPattern(boolean findDeclarations, boolean findReferences, boolean isFunction, char[] selector, int selectorMatchRule) {
        this(findDeclarations, findReferences, isFunction, selector, null, null, null, null, null, null, selectorMatchRule);
    }

    public MethodPattern(boolean findDeclarations, boolean findReferences, char[] selector, char[][] possibleDeclaringTypes, int selectorMatchRule) {
        this(selectorMatchRule, true);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        char[] cArray = this.selector = this.isCaseSensitive() || this.isCamelCase() ? selector : CharOperation.toLowerCase(selector);
        if (possibleDeclaringTypes != null) {
            this.declaringQualification = new char[possibleDeclaringTypes.length][];
            this.declaringSimpleName = new char[possibleDeclaringTypes.length][];
            int i = 0;
            while (i < possibleDeclaringTypes.length) {
                char[][] seperatedDeclaringType = QualificationHelpers.seperateFullyQualifedName(possibleDeclaringTypes[i]);
                this.declaringQualification[i] = this.isCaseSensitive() ? seperatedDeclaringType[0] : CharOperation.toLowerCase(seperatedDeclaringType[0]);
                this.declaringSimpleName[i] = this.isCaseSensitive() ? seperatedDeclaringType[1] : CharOperation.toLowerCase(seperatedDeclaringType[1]);
                ++i;
            }
        } else {
            this.declaringQualification = null;
            this.declaringSimpleName = null;
        }
    }

    public MethodPattern(boolean findDeclarations, boolean findReferences, boolean isFunction, char[] selector, char[][] parameterQualifications, char[][] parameterSimpleNames, char[] returnQualification, char[] returnSimpleName, char[] declaringQualification, char[] declaringSimpleName, int matchRule) {
        this(matchRule, isFunction);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        this.selector = this.isCaseSensitive() || this.isCamelCase() ? selector : CharOperation.toLowerCase(selector);
        this.setDeclaringQualification(this.isCaseSensitive() ? declaringQualification : CharOperation.toLowerCase(declaringQualification));
        this.setDeclaringSimpleName(this.isCaseSensitive() ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName));
        this.returnQualification = this.isCaseSensitive() ? returnQualification : CharOperation.toLowerCase(returnQualification);
        char[] cArray = this.returnSimpleName = this.isCaseSensitive() ? returnSimpleName : CharOperation.toLowerCase(returnSimpleName);
        if (parameterSimpleNames != null) {
            this.parameterQualifications = new char[parameterSimpleNames.length][];
            this.parameterSimpleNames = new char[parameterSimpleNames.length][];
            int i = 0;
            while (i < this.parameterSimpleNames.length) {
                this.parameterQualifications[i] = this.isCaseSensitive() ? parameterQualifications[i] : CharOperation.toLowerCase(parameterQualifications[i]);
                this.parameterSimpleNames[i] = this.isCaseSensitive() ? parameterSimpleNames[i] : CharOperation.toLowerCase(parameterSimpleNames[i]);
                ++i;
            }
        }
        this.mustResolve = false;
    }

    @Override
    public void decodeIndexKey(char[] key) {
        char[][] seperated = CharOperation.splitOn('/', key);
        this.selector = seperated[0];
        char[][] parameterNames = CharOperation.splitOn(',', seperated[2]);
        this.parameterNames = (char[][])(parameterNames.length > 0 ? parameterNames : null);
        char[][][] parameterTypes = QualificationHelpers.seperateFullyQualifiedNames(seperated[1], parameterNames.length);
        this.parameterQualifications = parameterTypes[0];
        this.parameterSimpleNames = parameterTypes[1];
        char[][] returnType = QualificationHelpers.seperateFullyQualifedName(seperated[3]);
        this.returnQualification = returnType[0];
        this.returnSimpleName = returnType[1];
        char[][] declaringType = QualificationHelpers.seperateFullyQualifedName(seperated[4]);
        this.setDeclaringQualification(declaringType[0]);
        this.setDeclaringSimpleName(declaringType[1]);
        this.modifiers = seperated[5][0] + seperated[5][1];
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new MethodPattern(8, this.isFunction);
    }

    @Override
    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? (this.isFunction ? FUNCTION_REF_AND_DECL_CATEGORIES : REF_AND_DECL_CATEGORIES) : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return this.isFunction ? FUNCTION_DECL_CATEGORIES : DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        boolean matches = false;
        if (decodedPattern instanceof MethodPattern) {
            MethodPattern pattern = (MethodPattern)decodedPattern;
            matches = this.matchesName(this.selector, pattern.selector);
            if (matches && this.declaringSimpleName != null) {
                boolean foundTypeMatch = false;
                int i = 0;
                while (i < this.declaringSimpleName.length) {
                    if (this.matchesName(this.declaringQualification[i], pattern.getDeclaringQualification()) && this.matchesName(this.declaringSimpleName[i], pattern.getDeclaringSimpleName())) {
                        foundTypeMatch = true;
                        break;
                    }
                    ++i;
                }
                if (!foundTypeMatch) {
                    matches = false;
                }
            }
        }
        return matches;
    }

    public char[] getDeclaringQualification() {
        return this.declaringQualification != null && this.declaringQualification.length > 0 ? this.declaringQualification[0] : null;
    }

    public char[] getDeclaringSimpleName() {
        return this.declaringSimpleName != null && this.declaringSimpleName.length > 0 ? this.declaringSimpleName[0] : null;
    }

    private void setDeclaringQualification(char[] declaringQualification) {
        this.declaringQualification = new char[1][];
        this.declaringQualification[0] = declaringQualification;
    }

    private void setDeclaringSimpleName(char[] declaringSimpleName) {
        this.declaringSimpleName = new char[1][];
        this.declaringSimpleName[0] = declaringSimpleName;
    }

    @Override
    boolean isPolymorphicSearch() {
        return this.findReferences;
    }

    @Override
    EntryResult[] queryIn(Index index) throws IOException {
        int matchRule;
        char[] key = this.selector;
        int matchRuleToUse = matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.isCamelCase) break;
                key = MethodPattern.createSearchIndexKey(this.selector, this.getDeclaringQualification(), this.getDeclaringSimpleName());
                matchRuleToUse &= 0xFFFFFFFF;
                matchRuleToUse |= 2;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                key = MethodPattern.createSearchIndexKey(this.selector, this.getDeclaringQualification(), this.getDeclaringSimpleName());
                break;
            }
            case 4: {
                Logger.log(2, "Regular expression matching is not yet implimented for MethodPattern");
            }
        }
        return index.query(this.getIndexCategories(), key, matchRuleToUse);
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "MethodCombinedPattern: " : "MethodDeclarationPattern: ");
        } else {
            output.append("MethodReferencePattern: ");
        }
        if (this.getDeclaringQualification() != null) {
            output.append(this.getDeclaringQualification()).append('.');
        }
        if (this.getDeclaringSimpleName() != null) {
            output.append(this.getDeclaringSimpleName()).append('.');
        } else if (this.getDeclaringQualification() != null) {
            output.append("*.");
        }
        if (this.selector != null) {
            output.append(this.selector);
        } else {
            output.append("*");
        }
        output.append('(');
        if (this.parameterSimpleNames == null) {
            output.append("...");
        } else {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (i > 0) {
                    output.append(", ");
                }
                if (this.parameterQualifications[i] != null) {
                    output.append(this.parameterQualifications[i]).append('.');
                }
                if (this.parameterSimpleNames[i] == null) {
                    output.append('*');
                } else {
                    output.append(this.parameterSimpleNames[i]);
                }
                ++i;
            }
        }
        output.append(')');
        if (this.returnQualification != null) {
            output.append(" --> ").append(this.returnQualification).append('.');
        } else if (this.returnSimpleName != null) {
            output.append(" --> ");
        }
        if (this.returnSimpleName != null) {
            output.append(this.returnSimpleName);
        } else if (this.returnQualification != null) {
            output.append("*");
        }
        return super.print(output);
    }

    public static char[] createIndexKey(char[] selector) {
        return MethodPattern.createIndexKey(selector, null, null, null, null, 0);
    }

    public static char[] createIndexKey(char[] selector, char[][] parameterFullTypeNames, char[][] parameterNames, char[] declaringFullTypeName, char[] returnFullTypeName, int modifiers) {
        char[] indexKey = null;
        if (selector != null && selector.length > 0) {
            char[] parameterTypesChars = CharOperation.NO_CHAR;
            char[] parameterNamesChars = CharOperation.NO_CHAR;
            if (parameterFullTypeNames != null) {
                parameterTypesChars = CharOperation.concatWith(parameterFullTypeNames, ',', false);
            }
            if (parameterNames != null) {
                parameterNamesChars = CharOperation.concatWith(parameterNames, ',');
            }
            int parameterTypesLength = parameterTypesChars == null ? 0 : parameterTypesChars.length;
            int parameterNamesLength = parameterNamesChars == null ? 0 : parameterNamesChars.length;
            int returnTypeLength = returnFullTypeName == null ? 0 : returnFullTypeName.length;
            int delaringTypeLength = declaringFullTypeName == null ? 0 : declaringFullTypeName.length;
            int resultLength = selector.length + 1 + parameterTypesLength + 1 + parameterNamesLength + 1 + returnTypeLength + 1 + delaringTypeLength + 3;
            indexKey = new char[resultLength];
            int pos = 0;
            System.arraycopy(selector, 0, indexKey, pos, selector.length);
            pos += selector.length;
            indexKey[pos++] = 47;
            if (parameterTypesLength > 0) {
                System.arraycopy(parameterTypesChars, 0, indexKey, pos, parameterTypesLength);
                pos += parameterTypesLength;
            }
            indexKey[pos++] = 47;
            if (parameterNamesLength > 0) {
                System.arraycopy(parameterNamesChars, 0, indexKey, pos, parameterNamesLength);
                pos += parameterNamesLength;
            }
            indexKey[pos++] = 47;
            if (returnTypeLength > 0) {
                System.arraycopy(returnFullTypeName, 0, indexKey, pos, returnTypeLength);
                pos += returnTypeLength;
            }
            indexKey[pos++] = 47;
            if (delaringTypeLength > 0) {
                System.arraycopy(declaringFullTypeName, 0, indexKey, pos, delaringTypeLength);
                pos += delaringTypeLength;
            }
            indexKey[pos++] = 47;
            indexKey[pos++] = (char)modifiers;
            indexKey[pos++] = (char)(modifiers >> 16);
        }
        return indexKey;
    }

    private static char[] createSearchIndexKey(char[] selector, char[] declaringQualification, char[] declaringSimpleName) {
        char[] declaringFullTypeName = null;
        if (declaringSimpleName != null) {
            declaringFullTypeName = QualificationHelpers.createFullyQualifiedName(declaringQualification, declaringSimpleName);
        }
        return MethodPattern.createIndexKey(selector, ONE_STAR_CHAR, ONE_STAR_CHAR, declaringFullTypeName != null ? declaringFullTypeName : ONE_STAR, ONE_STAR, 0);
    }
}

