/*******************************************************************************
 * Copyright (c) 2023, 2025 Ericsson
 *
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/

package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model;

import org.eclipse.jdt.annotation.NonNullByDefault;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema.AdditionalPropertiesValue;
import io.swagger.v3.oas.annotations.media.Schema.RequiredMode;

/**
 * Contributes to the model used for TSP swagger-core annotations.
 */
@NonNullByDefault
@Schema(description = "Configuration instance describing user provided configuration parameters.")
public interface Configuration {
    /**
     * @return the name of configuration instance
     */
    @Schema(description = "The human readable name", requiredMode = RequiredMode.REQUIRED)
    String getName();

    /**
     * @return the ID for of the configuration instance.
     */
    @Schema(description = "The unique ID of the configuration instance", requiredMode = RequiredMode.REQUIRED)
    String getId();

    /**
     * @return a short description of this configuration instance.
     */
    @Schema(description = "Optional, describes the configuration instance")
    String getDescription();

    /**
     * @return the configuration source type
     */
    @Schema(description = "The ID of the configuration source type", requiredMode = RequiredMode.REQUIRED)
    String getSourceTypeId();

    /**
     * @return parameters to return. Can be used to show
     *         more details to users of the configuration instance
     */
    @Schema(description = "Optional parameters representing the configuration parameters used to create this configuration.", additionalProperties = AdditionalPropertiesValue.TRUE)
    Object getParameters();
}
