/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.scripting.ui.views;

import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.incubator.internal.scripting.ui.views.timegraph.ScriptedTimeGraphView;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ViewModule {
    public static final String MODULE_ID = "/TraceCompass/Views";

    @WrapToScript
    public void openTimeGraphView(ITimeGraphDataProvider<TimeGraphEntryModel> dataProvider) {
        Display.getDefault().asyncExec(() -> {
            try {
                IViewPart view = ViewModule.openView(dataProvider.getId());
                if (view instanceof ScriptedTimeGraphView) {
                    ((ScriptedTimeGraphView)view).refreshIfNeeded();
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        });
    }

    private static @Nullable IViewPart openView(String name) throws PartInitException {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        return activePage.showView("org.eclipse.tracecompass.incubator.scripting.ui.view.timegraph", name.replace(":", "[COLON]"), 1);
    }

    @WrapToScript
    public void showView(String viewId, @ScriptParameter(defaultValue="") String secondaryId) {
        Display.getDefault().asyncExec(() -> {
            try {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                IViewPart view = secondaryId.isEmpty() ? activePage.showView(viewId) : activePage.showView(viewId, secondaryId, 1);
                if (view instanceof ScriptedTimeGraphView) {
                    ((ScriptedTimeGraphView)view).refreshIfNeeded();
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        });
    }

    @WrapToScript
    public void openXYChartView(final ITmfTreeXYDataProvider<ITmfTreeDataModel> dataProvider) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewPart view = ViewModule.openXYView(dataProvider.getId());
                    if (view == null) {
                        return;
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
    }

    private static @Nullable IViewPart openXYView(String name) throws PartInitException {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        return activePage.showView("org.eclipse.tracecompass.incubator.internal.scripting.ui.views.xychart", name.replace(":", "[COLON]"), 1);
    }
}

