/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.ui.views.xychart;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.incubator.internal.scripting.ui.views.xychart.Messages;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class ScriptedXYTreeViewer
extends AbstractSelectTreeViewer {
    private final String fProviderId;

    public ScriptedXYTreeViewer(Composite parent, String name) {
        super(parent, 1, name);
        this.setLabelProvider((IBaseLabelProvider)new ScriptedLabelProvider());
        this.fProviderId = name;
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return () -> ImmutableList.of((Object)ScriptedXYTreeViewer.createColumn((String)Messages.ScriptedXYTreeViewer_Name, Comparator.comparing(TmfTreeViewerEntry::getName)), (Object)new TmfTreeColumnData(Messages.ScriptedXYTreeViewer_Legend));
    }

    protected ITmfTreeDataProvider<@NonNull ITmfTreeDataModel> getProvider(ITmfTrace trace) {
        if (this.fProviderId == null) {
            return null;
        }
        return DataProviderManager.getInstance().getDataProvider(trace, this.fProviderId, ITmfTreeDataProvider.class);
    }

    private class ScriptedLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        private ScriptedLabelProvider() {
        }

        public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
            if (columnIndex == 1 && element instanceof TmfGenericTreeEntry && ScriptedXYTreeViewer.this.isChecked(element)) {
                TmfTreeDataModel model = (TmfTreeDataModel)((TmfGenericTreeEntry)element).getModel();
                if (model.getParentId() < 0L) {
                    return null;
                }
                return ScriptedXYTreeViewer.this.getLegendImage(String.valueOf(model.getName()));
            }
            return null;
        }
    }
}

