/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.ui.views.timegraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class BasePresentationProvider
extends TimeGraphPresentationProvider {
    private static final long[] COLOR_SEED;
    private static final int COLOR_MASK = 0xFFFFFF;
    private List<StateItem> fStateValues = new ArrayList<StateItem>();
    private @Nullable Integer fAverageCharacterWidth = null;
    private Map<Integer, Integer> fStateIndex = new HashMap<Integer, Integer>();
    private Map<String, Integer> fLabelMap = new HashMap<String, Integer>();
    private StateItem[] stateTable = new StateItem[0];

    static {
        long[] lArray = new long[8];
        lArray[0] = 255L;
        lArray[1] = 0xFF0000L;
        lArray[2] = 65280L;
        lArray[3] = 0xFF00FFL;
        lArray[4] = 65535L;
        lArray[5] = 0xFFFF00L;
        lArray[7] = 15758080L;
        COLOR_SEED = lArray;
    }

    public int getStateTableIndex(@Nullable ITimeEvent event) {
        String label;
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            TimeEvent tcEvent = (TimeEvent)event;
            Integer value = tcEvent.getValue();
            Integer index = this.fStateIndex.get(value);
            if (index != null) {
                return index;
            }
            String label2 = String.valueOf(value);
            index = this.fLabelMap.get(label2);
            if (index == null) {
                index = this.addState(label2);
            }
            if ((value = this.fStateIndex.get(index)) != null) {
                return value;
            }
        } else if (event instanceof TimeEvent && !((TimeEvent)event).hasValue() && (label = event.getLabel()) != null) {
            Integer value;
            Integer index = this.fLabelMap.get(label);
            if (index == null) {
                index = this.addState(label);
            }
            if ((value = this.fStateIndex.get(index)) != null) {
                return value;
            }
        }
        return -2;
    }

    public StateItem[] getStateTable() {
        return this.stateTable;
    }

    public @Nullable String getEventName(@Nullable ITimeEvent event) {
        if (event == null) {
            return null;
        }
        String label = event.getLabel();
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            TimeEvent tcEvent = (TimeEvent)event;
            int value = tcEvent.getValue();
            Integer index = this.fStateIndex.get(value);
            if (index != null) {
                return this.fStateValues.get(index).getStateString();
            }
            return null;
        }
        if (label != null) {
            return label;
        }
        return null;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        return Collections.emptyMap();
    }

    @Deprecated
    private static int getAverageCharWidth(GC gc) {
        return gc.getFontMetrics().getAverageCharWidth();
    }

    public void postDrawEvent(@Nullable ITimeEvent event, @Nullable Rectangle bounds, @Nullable GC gc) {
        if (event == null || bounds == null || gc == null) {
            return;
        }
        Integer averageCharacterWidth = this.fAverageCharacterWidth;
        if (averageCharacterWidth == null) {
            this.fAverageCharacterWidth = averageCharacterWidth = Integer.valueOf(BasePresentationProvider.getAverageCharWidth(gc));
        }
        if (bounds.width <= averageCharacterWidth) {
            return;
        }
        String eventName = this.getEventName(event);
        if (eventName == null) {
            return;
        }
        Color stateColor = gc.getBackground();
        gc.setForeground(Utils.getDistinctColor((RGB)stateColor.getRGB()));
        Utils.drawText((GC)gc, (String)eventName, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
    }

    public synchronized int addState(String name) {
        int value = 10000;
        while (this.fStateIndex.get(value) != null) {
            ++value;
        }
        this.addOrUpdateState(value, name);
        Display.getDefault().asyncExec(() -> ((BasePresentationProvider)this).fireColorSettingsChanged());
        return value;
    }

    private synchronized void addOrUpdateState(int value, String name) {
        if (value < 0) {
            return;
        }
        RGB colorRGB = BasePresentationProvider.calcColor(name);
        StateItem item = new StateItem(colorRGB, name);
        Integer index = this.fStateIndex.get(value);
        if (index == null) {
            this.fStateIndex.put(value, this.fStateValues.size());
            this.fStateValues.add(item);
            this.fLabelMap.put(name, value);
        } else {
            this.fStateValues.set(index, item);
        }
        this.stateTable = this.fStateValues.toArray(new StateItem[this.fStateValues.size()]);
    }

    private static RGB calcColor(String name) {
        long hash = name.hashCode();
        long base = COLOR_SEED[(int)(Math.abs(hash) % (long)COLOR_SEED.length)];
        int x = (int)(hash & 0xFFFFFFL ^ base);
        int r = x >> 16 & 0xFF;
        int g = x >> 8 & 0xFF;
        int b = x & 0xFF;
        return new RGB(r, g, b);
    }

    public boolean hasIndex(int status) {
        return this.fStateIndex.containsKey(status);
    }
}

