/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.ui.project.wizards;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.incubator.internal.opentracing.ui.project.handlers.SplitImportTracesOperation;
import org.eclipse.tracecompass.incubator.internal.opentracing.ui.project.wizards.JaegerRestUtils;
import org.eclipse.tracecompass.incubator.internal.opentracing.ui.project.wizards.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;

public class FetchJaegerTracesWizardPage
extends WizardPage {
    private static final String DEFAULT_TRACE_FOLDER_NAME = "jaegerTraces";
    private static final String DEFAULT_LIMIT = "20";
    private static final String DEFAULT_BASE_URL = "http://localhost:16686/api";
    private static final String[] DEFAULT_LOOKBACKS = new String[]{"1h", "2h", "3h", "6h", "12h", "1d", "2d"};
    private static final Long[] DEFAULT_LOOKBACKS_SECONDS = new Long[]{3600L, 7200L, 10800L, 21600L, 43200L, 86400L, 172800L};
    private static final String NANOSECONDS_PADDING = "000";
    private static final String JAEGER_DATA_KEY = "data";
    private static final String JAEGER_SPANS_KEY = "spans";
    private static final String JAEGER_TRACE_ID_KEY = "traceID";
    private static final String JAEGER_SPAN_NAME_KEY = "operationName";
    private static final String JAEGER_PROCESSES_KEY = "processes";
    private static final String JAEGER_SERVICE_KEY = "serviceName";
    private Table fTracesTable;
    private String fTraceFolderName;
    private TmfTraceFolder fTmfTraceFolder;
    private JsonObject fJaegerJsonTrace;

    public FetchJaegerTracesWizardPage(IStructuredSelection selection) {
        super(Messages.FetchJaegerTracesWizardPage_wizardPageName, Messages.FetchJaegerTracesWizardPage_wizardPageName, null);
        if (selection.getFirstElement() instanceof TmfTraceFolder) {
            this.fTmfTraceFolder = (TmfTraceFolder)selection.getFirstElement();
        }
        this.updatePageCompletion();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Group urlConfigurationGroup = new Group(composite, 0);
        urlConfigurationGroup.setText(Messages.FetchJaegerTracesWizardPage_jaegerConfigGroup);
        urlConfigurationGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        urlConfigurationGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label targetUrlLabel = new Label((Composite)urlConfigurationGroup, 0);
        targetUrlLabel.setText(Messages.FetchJaegerTracesWizardPage_apiBaseUrlLabel);
        final Text targetUrlText = new Text((Composite)urlConfigurationGroup, 0);
        targetUrlText.setText(DEFAULT_BASE_URL);
        targetUrlText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label serviceLabel = new Label((Composite)urlConfigurationGroup, 0);
        serviceLabel.setText(Messages.FetchJaegerTracesWizardPage_serviceNameLabel);
        final Combo serviceCombo = new Combo((Composite)urlConfigurationGroup, 4);
        serviceCombo.setItems(new String[0]);
        serviceCombo.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        targetUrlText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (!JaegerRestUtils.jaegerCheckConnection(targetUrlText.getText())) {
                    FetchJaegerTracesWizardPage.this.setPageComplete(false);
                    FetchJaegerTracesWizardPage.this.setErrorMessage(Messages.FetchJaegerTracesWizardPage_errorApiConnection);
                } else {
                    String[] fetchServices = JaegerRestUtils.fetchServices(targetUrlText.getText());
                    if (fetchServices != null) {
                        serviceCombo.setItems(fetchServices);
                        serviceCombo.select(0);
                    }
                }
            }

            public void focusGained(FocusEvent e) {
                FetchJaegerTracesWizardPage.this.updatePageCompletion();
            }
        });
        Label targetTagsLabel = new Label((Composite)urlConfigurationGroup, 0);
        targetTagsLabel.setText(Messages.FetchJaegerTracesWizardPage_tagsLabel);
        final Text targetTagsText = new Text((Composite)urlConfigurationGroup, 0);
        targetTagsText.setMessage("http.method=GET error=true");
        targetTagsText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label traceNumberLimitLabel = new Label((Composite)urlConfigurationGroup, 0);
        traceNumberLimitLabel.setText(Messages.FetchJaegerTracesWizardPage_nbTracesLimitLabel);
        final Text traceNumberLimitText = new Text((Composite)urlConfigurationGroup, 0);
        traceNumberLimitText.setText(DEFAULT_LIMIT);
        traceNumberLimitText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label traceLookBackLabel = new Label((Composite)urlConfigurationGroup, 0);
        traceLookBackLabel.setText(Messages.FetchJaegerTracesWizardPage_lookbackLabel);
        final Combo lookbackCombo = new Combo((Composite)urlConfigurationGroup, 4);
        lookbackCombo.setItems(DEFAULT_LOOKBACKS);
        lookbackCombo.select(0);
        lookbackCombo.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label targetMinDurationLabel = new Label((Composite)urlConfigurationGroup, 0);
        targetMinDurationLabel.setText(Messages.FetchJaegerTracesWizardPage_minDurationLabel);
        final Text targetMinDurationText = new Text((Composite)urlConfigurationGroup, 0);
        targetMinDurationText.setMessage("100ms");
        targetMinDurationText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        targetMinDurationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (targetMinDurationText.getText().isEmpty()) {
                    targetTagsText.setEnabled(true);
                } else {
                    targetTagsText.setEnabled(false);
                }
                FetchJaegerTracesWizardPage.this.updatePageCompletion();
            }
        });
        targetTagsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (targetTagsText.getText().isEmpty()) {
                    targetMinDurationText.setEnabled(true);
                } else {
                    targetMinDurationText.setEnabled(false);
                }
                FetchJaegerTracesWizardPage.this.updatePageCompletion();
            }
        });
        Label targetMaxDurationLabel = new Label((Composite)urlConfigurationGroup, 0);
        targetMaxDurationLabel.setText(Messages.FetchJaegerTracesWizardPage_maxDurationLabel);
        final Text targetMaxDurationText = new Text((Composite)urlConfigurationGroup, 0);
        targetMaxDurationText.setMessage("1.1s");
        targetMaxDurationText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label traceNameLabel = new Label((Composite)urlConfigurationGroup, 0);
        traceNameLabel.setText(Messages.FetchJaegerTracesWizardPage_traceName);
        final Text traceFolderNameText = new Text((Composite)urlConfigurationGroup, 0);
        traceFolderNameText.setText(DEFAULT_TRACE_FOLDER_NAME);
        traceFolderNameText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.fTraceFolderName = DEFAULT_TRACE_FOLDER_NAME;
        Label traceDestinationLabel = new Label((Composite)urlConfigurationGroup, 0);
        traceDestinationLabel.setText(Messages.FetchJaegerTracesWizardPage_importDestinationLabel);
        final Text traceDestinationText = new Text((Composite)urlConfigurationGroup, 0);
        traceDestinationText.setText(this.fTmfTraceFolder.getPath().append(this.fTraceFolderName).toOSString());
        traceDestinationText.setEnabled(false);
        traceDestinationText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        traceFolderNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FetchJaegerTracesWizardPage.this.fTraceFolderName = traceFolderNameText.getText();
                traceDestinationText.setText(FetchJaegerTracesWizardPage.this.fTmfTraceFolder.getPath().append(FetchJaegerTracesWizardPage.this.fTraceFolderName).toOSString());
                FetchJaegerTracesWizardPage.this.updatePageCompletion();
            }
        });
        final Group tracesInfoGroup = new Group(composite, 0);
        tracesInfoGroup.setText(Messages.FetchJaegerTracesWizardPage_tracesGroup);
        tracesInfoGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        tracesInfoGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Button fetchJagerButton = new Button((Composite)urlConfigurationGroup, 8);
        fetchJagerButton.setText(Messages.FetchJaegerTracesWizardPage_jaegerFetchButton);
        fetchJagerButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        fetchJagerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long endTime = Instant.now().toEpochMilli();
                long startTime = Instant.now().minusSeconds(DEFAULT_LOOKBACKS_SECONDS[lookbackCombo.indexOf(lookbackCombo.getText())]).toEpochMilli();
                String tags = FetchJaegerTracesWizardPage.buildTagsString(targetTagsText.getText());
                String requestUrl = JaegerRestUtils.buildTracesUrl(targetUrlText.getText(), String.valueOf(Long.toString(endTime)) + FetchJaegerTracesWizardPage.NANOSECONDS_PADDING, traceNumberLimitText.getText(), lookbackCombo.getText(), targetMaxDurationText.getText(), targetMinDurationText.getText(), serviceCombo.getText(), String.valueOf(Long.toString(startTime)) + FetchJaegerTracesWizardPage.NANOSECONDS_PADDING, tags);
                String jaegerTraces = JaegerRestUtils.fetchJaegerTraces(requestUrl);
                if (jaegerTraces == null) {
                    FetchJaegerTracesWizardPage.this.setPageComplete(false);
                    FetchJaegerTracesWizardPage.this.setErrorMessage(Messages.FetchJaegerTracesWizardPage_errorFetchTraces);
                    return;
                }
                Gson gson = new Gson();
                JsonObject tracesObject = (JsonObject)gson.fromJson(jaegerTraces, JsonObject.class);
                JsonArray tracesArray = tracesObject.get(FetchJaegerTracesWizardPage.JAEGER_DATA_KEY).getAsJsonArray();
                FetchJaegerTracesWizardPage.this.fTracesTable.removeAll();
                tracesInfoGroup.setText(String.valueOf(Messages.FetchJaegerTracesWizardPage_tracesGroup) + " (" + tracesArray.size() + ')');
                if (tracesArray.size() > 0) {
                    int i = 0;
                    while (i < tracesArray.size()) {
                        TableItem traceItem = new TableItem(FetchJaegerTracesWizardPage.this.fTracesTable, 0);
                        JsonObject trace = tracesArray.get(i).getAsJsonObject();
                        JsonArray spans = trace.get(FetchJaegerTracesWizardPage.JAEGER_SPANS_KEY).getAsJsonArray();
                        traceItem.setText(0, spans.get(0).getAsJsonObject().get(FetchJaegerTracesWizardPage.JAEGER_SPAN_NAME_KEY).getAsString());
                        traceItem.setText(1, Integer.toString(spans.size()));
                        traceItem.setText(2, StringUtils.join((Object[])FetchJaegerTracesWizardPage.fetchTraceServices(trace), (String)", "));
                        traceItem.setText(3, trace.get(FetchJaegerTracesWizardPage.JAEGER_TRACE_ID_KEY).getAsString());
                        traceItem.setChecked(true);
                        TableColumn[] tableColumnArray = FetchJaegerTracesWizardPage.this.fTracesTable.getColumns();
                        int n = tableColumnArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableColumn column = tableColumnArray[n2];
                            column.pack();
                            ++n2;
                        }
                        ++i;
                    }
                    FetchJaegerTracesWizardPage.this.fJaegerJsonTrace = tracesObject;
                    FetchJaegerTracesWizardPage.this.updatePageCompletion();
                } else {
                    FetchJaegerTracesWizardPage.this.setPageComplete(false);
                    FetchJaegerTracesWizardPage.this.setErrorMessage(Messages.FetchJaegerTracesWizardPage_errorNoTracesFound);
                }
            }
        });
        this.fTracesTable = new Table((Composite)tracesInfoGroup, 802);
        this.fTracesTable.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fTracesTable.setLinesVisible(true);
        this.fTracesTable.setHeaderVisible(true);
        TableColumn firstSpanColumn = new TableColumn(this.fTracesTable, 0);
        firstSpanColumn.setText(Messages.FetchJaegerTracesWizardPage_spanNameColumnName);
        firstSpanColumn.pack();
        TableColumn nbSpanColumn = new TableColumn(this.fTracesTable, 0);
        nbSpanColumn.setText(Messages.FetchJaegerTracesWizardPage_nbSpansColumnName);
        nbSpanColumn.pack();
        TableColumn servicesColumn = new TableColumn(this.fTracesTable, 0);
        servicesColumn.setText(Messages.FetchJaegerTracesWizardPage_servicesColumnName);
        servicesColumn.pack();
        TableColumn traceIdColumn = new TableColumn(this.fTracesTable, 0);
        traceIdColumn.setText(Messages.FetchJaegerTracesWizardPage_traceIdColumnName);
        traceIdColumn.pack();
        this.fTracesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    FetchJaegerTracesWizardPage.this.updatePageCompletion();
                }
            }
        });
        Composite selectOptionsComposite = new Composite((Composite)tracesInfoGroup, 0);
        selectOptionsComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Button selectAllButton = new Button(selectOptionsComposite, 8);
        selectAllButton.setText(Messages.FetchJaegerTracesWizardPage_selectAllButton);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = FetchJaegerTracesWizardPage.this.fTracesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    tableItem.setChecked(true);
                    ++n2;
                }
                FetchJaegerTracesWizardPage.this.updatePageCompletion();
            }
        });
        Button deselectAllButton = new Button(selectOptionsComposite, 8);
        deselectAllButton.setText(Messages.FetchJaegerTracesWizardPage_deselectAllButton);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = FetchJaegerTracesWizardPage.this.fTracesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    tableItem.setChecked(false);
                    ++n2;
                }
                FetchJaegerTracesWizardPage.this.updatePageCompletion();
            }
        });
        this.setMessage(Messages.FetchJaegerTracesWizardPage_wizardDescriptionMessage);
        this.setControl((Control)composite);
    }

    public boolean performFinish() {
        TmfTraceFolder tracesFolder = this.fTmfTraceFolder.getProject().getTracesFolder();
        if (tracesFolder != null) {
            List<String> checkedTraceIds = this.getCheckedTraces();
            IPath destinationFolderPath = this.fTmfTraceFolder.getPath().append(this.fTraceFolderName);
            String destinationSubPath = destinationFolderPath.makeRelativeTo(tracesFolder.getPath()).toOSString();
            SplitImportTracesOperation.splitAndImport(this.fJaegerJsonTrace, checkedTraceIds, destinationSubPath, tracesFolder);
            return true;
        }
        return false;
    }

    private List<String> getCheckedTraces() {
        ArrayList<String> traceIdList = new ArrayList<String>();
        TableItem[] tableItemArray = this.fTracesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem traceItem = tableItemArray[n2];
            if (traceItem.getChecked()) {
                traceIdList.add(traceItem.getText(3));
            }
            ++n2;
        }
        return traceIdList;
    }

    private void updatePageCompletion() {
        this.setErrorMessage(null);
        if (this.fJaegerJsonTrace == null || this.fJaegerJsonTrace.get(JAEGER_DATA_KEY).getAsJsonArray().size() == 0) {
            this.setPageComplete(false);
            return;
        }
        if (this.getCheckedTraces().isEmpty()) {
            this.setPageComplete(false);
            return;
        }
        if (this.fTmfTraceFolder.getResource().findMember(this.fTraceFolderName) != null) {
            this.setErrorMessage(Messages.FetchJaegerTracesWizardPage_errorFileName);
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    private static String buildTagsString(String tags) {
        if (!tags.isEmpty()) {
            String[] tagsArray = tags.split(" ");
            JsonObject jsonTags = new JsonObject();
            int i = 0;
            while (i < tagsArray.length) {
                String[] tagKeyValue = tagsArray[i].split("=");
                jsonTags.addProperty(tagKeyValue[0], tagKeyValue[1]);
                ++i;
            }
            return jsonTags.toString();
        }
        return tags;
    }

    private static String[] fetchTraceServices(JsonObject trace) {
        JsonObject servicesArray = trace.get(JAEGER_PROCESSES_KEY).getAsJsonObject();
        String[] services = new String[servicesArray.size()];
        int i = 0;
        while (i < servicesArray.size()) {
            services[i] = servicesArray.get("p" + (i + 1)).getAsJsonObject().get(JAEGER_SERVICE_KEY).getAsString();
            ++i;
        }
        return services;
    }
}

