/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.StatusInfo;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class AccessibilityPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private OverlayPreferenceStore fOverlayStore;
    private boolean fFieldsInitialized = false;
    private List<Initializer> fInitializers = new ArrayList<Initializer>();
    private InitializerFactory fInitializerFactory = new InitializerFactory();
    private Control fContents;
    private ArrayList<SelectionListener> fMasterSlaveListeners = new ArrayList();

    public AccessibilityPreferencePage() {
        this.setDescription(TextEditorMessages.AccessibilityPreferencePage_accessibility_title);
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    protected Label createDescriptionLabel(Composite parent) {
        return null;
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Accessibility.UseCustomCarets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Accessibility.WideCaret"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "quickdiff.characterMode"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "Accessibility.UseSaturatedColors"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.accessibility_preference_page_context");
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        appearanceComposite.setLayout((Layout)layout);
        String label = TextEditorMessages.TextEditorPreferencePage_accessibility_disableCustomCarets;
        Preference customCarets = new Preference("AbstractTextEditor.Accessibility.UseCustomCarets", label, null);
        Button master = this.addCheckBox(appearanceComposite, customCarets, new BooleanDomain(), 0);
        label = TextEditorMessages.TextEditorPreferencePage_accessibility_wideCaret;
        Preference wideCaret = new Preference("AbstractTextEditor.Accessibility.WideCaret", label, null);
        Button slave = this.addCheckBox(appearanceComposite, wideCaret, new BooleanDomain(), 0);
        this.createDependency(master, customCarets, new Control[]{slave});
        label = TextEditorMessages.QuickDiffConfigurationBlock_characterMode;
        Preference quickDiffTextMode = new Preference("quickdiff.characterMode", label, null);
        this.addCheckBox(appearanceComposite, quickDiffTextMode, new BooleanDomain(), 0);
        label = TextEditorMessages.TextEditorPreferencePage_accessibility_useSaturatedColorsInOverviewRuler;
        Preference useSaturatedColors = new Preference("Accessibility.UseSaturatedColors", label, null);
        this.addCheckBox(appearanceComposite, useSaturatedColors, new BooleanDomain(), 0);
        return appearanceComposite;
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        this.fContents = this.createAppearancePage(parent);
        this.initialize();
        Dialog.applyDialogFont((Control)this.fContents);
        return this.fContents;
    }

    private void initialize() {
        this.initializeFields();
    }

    private void initializeFields() {
        for (Initializer initializer : this.fInitializers) {
            initializer.initialize();
        }
        this.fFieldsInitialized = true;
        this.updateStatus(new StatusInfo());
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        for (SelectionListener listener : this.fMasterSlaveListeners) {
            listener.widgetSelected(null);
        }
        super.performDefaults();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private Button addCheckBox(Composite composite, final Preference preference, final Domain domain, int indentation) {
        final Button checkBox = new Button(composite, 32);
        checkBox.setText(preference.getName());
        checkBox.setToolTipText(preference.getDescription());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean value = checkBox.getSelection();
                IStatus status = domain.validate(value);
                if (!status.matches(4)) {
                    AccessibilityPreferencePage.this.fOverlayStore.setValue(preference.getKey(), value);
                }
                AccessibilityPreferencePage.this.updateStatus(status);
            }
        });
        this.fInitializers.add(this.fInitializerFactory.create(preference, checkBox));
        return checkBox;
    }

    private void createDependency(final Button master, Preference preference, final Control[] slaves) {
        AccessibilityPreferencePage.indent(slaves[0]);
        boolean masterState = this.fOverlayStore.getBoolean(preference.getKey());
        int i = 0;
        while (i < slaves.length) {
            slaves[i].setEnabled(masterState);
            ++i;
        }
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = master.getSelection();
                int i = 0;
                while (i < slaves.length) {
                    slaves[i].setEnabled(state);
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    void updateStatus(IStatus status) {
        if (!this.fFieldsInitialized) {
            return;
        }
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    public void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    static class BooleanDomain
    extends Domain {
        BooleanDomain() {
        }

        @Override
        public IStatus validate(Object value) {
            StatusInfo status = new StatusInfo();
            if (value instanceof String && ((String)value).length() == 0) {
                status.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return status;
            }
            try {
                this.parseBoolean(value);
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(value)));
            }
            return status;
        }

        private boolean parseBoolean(Object value) throws NumberFormatException {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                if (Boolean.TRUE.toString().equalsIgnoreCase((String)value)) {
                    return true;
                }
                if (Boolean.FALSE.toString().equalsIgnoreCase((String)value)) {
                    return false;
                }
            }
            throw new NumberFormatException(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(value)));
        }
    }

    static abstract class Domain {
        Domain() {
        }

        public abstract IStatus validate(Object var1);

        protected int parseInteger(Object val) throws NumberFormatException {
            if (val instanceof Integer) {
                return (Integer)val;
            }
            if (val instanceof String) {
                return Integer.parseInt((String)val);
            }
            throw new NumberFormatException(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(val)));
        }
    }

    static class EnumeratedDomain
    extends Domain {
        private final List<EnumValue> fItems = new ArrayList<EnumValue>();
        private final Set<EnumValue> fValueSet = new HashSet<EnumValue>();

        EnumeratedDomain() {
        }

        public void addValue(EnumValue val) {
            if (this.fValueSet.contains(val)) {
                this.fItems.remove(val);
            }
            this.fItems.add(val);
            this.fValueSet.add(val);
        }

        public int getIndex(EnumValue enumValue) {
            int i = 0;
            for (EnumValue ev : this.fItems) {
                if (ev.equals(enumValue)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public EnumValue getValueByIndex(int index) {
            if (index >= 0 && this.fItems.size() > index) {
                return this.fItems.get(index);
            }
            return null;
        }

        public EnumValue getValueByInteger(int intValue) {
            for (EnumValue e : this.fItems) {
                if (e.getIntValue() != intValue) continue;
                return e;
            }
            return null;
        }

        public void addValue(int val) {
            this.addValue(new EnumValue(val));
        }

        public void addRange(int from, int to) {
            while (from <= to) {
                this.addValue(from++);
            }
        }

        @Override
        public IStatus validate(Object value) {
            StatusInfo status = new StatusInfo();
            if (value instanceof String && ((String)value).length() == 0) {
                status.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return status;
            }
            try {
                EnumValue e = this.parseEnumValue(value);
                if (!this.fValueSet.contains(e)) {
                    status.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidRange, new String[]{this.getValueByIndex(0).getLabel(), this.getValueByIndex(this.fItems.size() - 1).getLabel()}));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(value)));
            }
            return status;
        }

        private EnumValue parseEnumValue(Object value) {
            if (value instanceof EnumValue) {
                return (EnumValue)value;
            }
            int integer = this.parseInteger(value);
            return this.getValueByInteger(integer);
        }

        public static final class EnumValue {
            private final int fValue;
            private final String fName;

            public EnumValue(int value) {
                this(value, null);
            }

            public EnumValue(int value, String name) {
                this.fValue = value;
                this.fName = name;
            }

            public String getLabel() {
                return this.fName == null ? String.valueOf(this.fValue) : this.fName;
            }

            public int getIntValue() {
                return this.fValue;
            }

            public final int hashCode() {
                return this.getIntValue();
            }

            public boolean equals(Object obj) {
                if (obj instanceof EnumValue) {
                    return ((EnumValue)obj).getIntValue() == this.fValue;
                }
                return false;
            }
        }
    }

    private abstract class Initializer {
        protected final Preference fPreference;

        protected Initializer(Preference preference) {
            this.fPreference = preference;
        }

        public abstract void initialize();
    }

    public final class InitializerFactory {
        public Initializer create(Preference preference, Text control) {
            return new TextInitializer(preference, control);
        }

        public Initializer create(Preference preference, Button control) {
            return new CheckboxInitializer(preference, control);
        }

        public Initializer create(Preference preference, Combo control, EnumeratedDomain domain) {
            return new ComboInitializer(preference, control, domain);
        }

        private class CheckboxInitializer
        extends Initializer {
            private final Button fControl;

            public CheckboxInitializer(Preference preference, Button control) {
                super(preference);
                this.fControl = control;
            }

            @Override
            public void initialize() {
                boolean value = AccessibilityPreferencePage.this.fOverlayStore.getBoolean(this.fPreference.getKey());
                this.fControl.setSelection(value);
            }
        }

        private class ComboInitializer
        extends Initializer {
            private final Combo fControl;
            private final EnumeratedDomain fDomain;

            public ComboInitializer(Preference preference, Combo control, EnumeratedDomain domain) {
                super(preference);
                this.fControl = control;
                this.fDomain = domain;
            }

            @Override
            public void initialize() {
                int index;
                int value = AccessibilityPreferencePage.this.fOverlayStore.getInt(this.fPreference.getKey());
                EnumeratedDomain.EnumValue enumValue = this.fDomain.getValueByInteger(value);
                if (enumValue != null && (index = this.fDomain.getIndex(enumValue)) >= 0) {
                    this.fControl.select(index);
                }
            }
        }

        private class TextInitializer
        extends Initializer {
            private final Text fText;

            public TextInitializer(Preference preference, Text control) {
                super(preference);
                this.fText = control;
            }

            @Override
            public void initialize() {
                String value = AccessibilityPreferencePage.this.fOverlayStore.getString(this.fPreference.getKey());
                this.fText.setText(value);
            }
        }
    }

    static class IntegerDomain
    extends Domain {
        private final int fMax;
        private final int fMin;

        public IntegerDomain(int min, int max) {
            Assert.isLegal((max >= min ? 1 : 0) != 0);
            this.fMax = max;
            this.fMin = min;
        }

        @Override
        public IStatus validate(Object value) {
            StatusInfo status = new StatusInfo();
            if (value instanceof String && ((String)value).length() == 0) {
                status.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return status;
            }
            try {
                int integer = this.parseInteger(value);
                if (!this.rangeCheck(integer)) {
                    status.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(integer)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(value)));
            }
            return status;
        }

        protected boolean rangeCheck(int i) {
            return i >= this.fMin && i <= this.fMax;
        }
    }

    private static class Preference {
        private String fKey;
        private String fName;
        private String fDescription;

        public Preference(String key, String name, String description) {
            Assert.isNotNull((Object)key);
            Assert.isNotNull((Object)name);
            this.fKey = key;
            this.fName = name;
            this.fDescription = description;
        }

        public final String getKey() {
            return this.fKey;
        }

        public final String getName() {
            return this.fName;
        }

        public final String getDescription() {
            return this.fDescription;
        }
    }
}

