/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.FlameGraphDataProvider;
import org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.xy.TmfTreeXYCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class FlameGraphDataProviderFactory
implements IDataProviderFactory {
    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        return null;
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace, String secondaryId) {
        ITmfTreeDataProvider<? extends ITmfTreeDataModel> provider = FlameGraphDataProviderFactory.create(trace, secondaryId);
        if (provider != null) {
            return provider;
        }
        Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        if (traces.size() > 1) {
            return TmfTreeXYCompositeDataProvider.create((Collection)traces, (String)Objects.requireNonNull(Messages.FlameGraphDataProvider_Title), (String)"org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.provider", (String)secondaryId);
        }
        return null;
    }

    private static @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> create(ITmfTrace trace, String secondaryId) {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ICallGraphProvider.class);
        Iterable filteredModules = Iterables.filter((Iterable)modules, m -> ((IAnalysisModule)m).getId().equals(secondaryId));
        Iterator iterator = filteredModules.iterator();
        if (iterator.hasNext()) {
            ICallGraphProvider module = (ICallGraphProvider)iterator.next();
            if (iterator.hasNext()) {
                return null;
            }
            ((IAnalysisModule)module).schedule();
            return new FlameGraphDataProvider(trace, module, secondaryId);
        }
        return null;
    }
}

