/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAlignmentSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public abstract class CASTBaseDeclSpecifier
extends ASTNode
implements ICASTDeclSpecifier,
IASTAmbiguityParent {
    protected int storageClass;
    protected boolean isConst;
    protected boolean isVolatile;
    protected boolean isRestrict;
    protected boolean isInline;
    protected IASTAlignmentSpecifier[] alignmentSpecifiers = IASTAlignmentSpecifier.EMPTY_ALIGNMENT_SPECIFIER_ARRAY;

    @Override
    public boolean isRestrict() {
        return this.isRestrict;
    }

    @Override
    public int getStorageClass() {
        return this.storageClass;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public boolean isInline() {
        return this.isInline;
    }

    @Override
    public IASTAlignmentSpecifier[] getAlignmentSpecifiers() {
        return this.alignmentSpecifiers;
    }

    @Override
    public void setStorageClass(int storageClass) {
        this.assertNotFrozen();
        this.storageClass = storageClass;
    }

    @Override
    public void setConst(boolean value) {
        this.assertNotFrozen();
        this.isConst = value;
    }

    @Override
    public void setVolatile(boolean value) {
        this.assertNotFrozen();
        this.isVolatile = value;
    }

    @Override
    public void setRestrict(boolean value) {
        this.assertNotFrozen();
        this.isRestrict = value;
    }

    @Override
    public void setInline(boolean value) {
        this.assertNotFrozen();
        this.isInline = value;
    }

    @Override
    public void setAlignmentSpecifiers(IASTAlignmentSpecifier[] alignmentSpecifiers) {
        this.assertNotFrozen();
        IASTAlignmentSpecifier[] iASTAlignmentSpecifierArray = alignmentSpecifiers;
        int n = alignmentSpecifiers.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAlignmentSpecifier specifier = iASTAlignmentSpecifierArray[n2];
            specifier.setParent(this);
            specifier.setPropertyInParent(ALIGNMENT_SPECIFIER);
            ++n2;
        }
        this.alignmentSpecifiers = alignmentSpecifiers;
    }

    @Override
    protected <T extends CASTBaseDeclSpecifier> T copy(T copy, IASTNode.CopyStyle style) {
        copy.storageClass = this.storageClass;
        copy.isConst = this.isConst;
        copy.isVolatile = this.isVolatile;
        copy.isRestrict = this.isRestrict;
        copy.isInline = this.isInline;
        copy.alignmentSpecifiers = new IASTAlignmentSpecifier[this.alignmentSpecifiers.length];
        int i = 0;
        while (i < this.alignmentSpecifiers.length) {
            copy.alignmentSpecifiers[i] = this.alignmentSpecifiers[i].copy(style);
            copy.alignmentSpecifiers[i].setParent(copy);
            ++i;
        }
        return super.copy(copy, style);
    }

    protected boolean visitAlignmentSpecifiers(ASTVisitor visitor) {
        IASTAlignmentSpecifier[] iASTAlignmentSpecifierArray = this.alignmentSpecifiers;
        int n = this.alignmentSpecifiers.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAlignmentSpecifier specifier = iASTAlignmentSpecifierArray[n2];
            if (!specifier.accept(visitor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child instanceof IASTAlignmentSpecifier && other instanceof IASTAlignmentSpecifier) {
            int i = 0;
            while (i < this.alignmentSpecifiers.length) {
                if (this.alignmentSpecifiers[i] == child) {
                    this.alignmentSpecifiers[i] = (IASTAlignmentSpecifier)other;
                    other.setParent(child.getParent());
                    other.setPropertyInParent(child.getPropertyInParent());
                    return;
                }
                ++i;
            }
        }
    }
}

