/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.operations;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.UpdateTraceBoundsJob;

public class SelectTracesOperation
implements IRunnableWithProgress {
    private final @Nullable TmfExperimentElement fExperimentElement;
    private final @Nullable TmfTraceFolder fParentTraceFolder;
    private final @Nullable List<TmfTraceElement> fTraceElements;
    private final @Nullable List<IResource> fResources;
    private final @Nullable Map<String, TmfTraceElement> fPreviousTraces;
    private @NonNull IStatus fStatus = Status.OK_STATUS;
    private final ITmfTimestamp fStartTimeRange;
    private final ITmfTimestamp fEndTimeRange;

    public SelectTracesOperation(@NonNull TmfExperimentFolder experimentFolderElement, @NonNull IFolder experiment, @NonNull TmfTraceFolder parentTraceFolder, @NonNull List<IResource> resources) {
        this(experimentFolderElement.getExperiment((IResource)experiment), parentTraceFolder, null, resources, null, null, null);
    }

    public SelectTracesOperation(@NonNull TmfExperimentElement experimentElement, @NonNull TmfTraceElement[] traces, @NonNull Map<String, TmfTraceElement> previousTraces) {
        this(experimentElement, null, traces, null, previousTraces, null, null);
    }

    public SelectTracesOperation(@NonNull TmfExperimentElement experimentElement, @NonNull TmfTraceElement[] traces, @NonNull Map<String, TmfTraceElement> previousTraces, ITmfTimestamp startTimeRange, ITmfTimestamp endTimeRange) {
        this(experimentElement, null, traces, null, previousTraces, startTimeRange, endTimeRange);
    }

    private SelectTracesOperation(TmfExperimentElement experimentElement, TmfTraceFolder parentTraceFolder, TmfTraceElement[] traces, List<IResource> resources, Map<String, TmfTraceElement> previousTraces, ITmfTimestamp startTimeRange, ITmfTimestamp endTimeRange) {
        this.fExperimentElement = experimentElement;
        this.fParentTraceFolder = parentTraceFolder;
        this.fTraceElements = traces == null ? null : new ArrayList<TmfTraceElement>(Arrays.asList(traces));
        this.fResources = resources;
        this.fPreviousTraces = previousTraces;
        if (startTimeRange != null && endTimeRange != null && startTimeRange.compareTo(endTimeRange) > 0) {
            this.fStartTimeRange = endTimeRange;
            this.fEndTimeRange = startTimeRange;
        } else {
            this.fStartTimeRange = startTimeRange;
            this.fEndTimeRange = endTimeRange;
        }
    }

    public void run(IProgressMonitor progressMonitor) {
        List<TmfTraceElement> elements;
        TmfExperimentElement experimentElement = this.fExperimentElement;
        if (experimentElement == null) {
            return;
        }
        boolean changed = false;
        Map<Object, Object> previousTraces = new HashMap();
        if (this.fPreviousTraces != null) {
            previousTraces = this.fPreviousTraces;
        }
        if ((elements = this.fTraceElements) == null) {
            if (this.fParentTraceFolder != null && this.fResources != null) {
                elements = this.fParentTraceFolder.getTraceElements(this.fResources);
            } else {
                return;
            }
        }
        Set<Object> keys = previousTraces.keySet();
        int workLoad = elements.size() + keys.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)workLoad);
        if (this.fStartTimeRange != null && this.fEndTimeRange != null) {
            subMonitor.setWorkRemaining(workLoad += elements.size());
            elements = this.filterTraceElementByTimeRange(elements, (IProgressMonitor)subMonitor.newChild(elements.size()));
        }
        subMonitor.setWorkRemaining(elements.size() + keys.size());
        try {
            for (TmfTraceElement tmfTraceElement : elements) {
                ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                String name = tmfTraceElement.getElementPath();
                if (keys.contains(name)) {
                    subMonitor.setTaskName(String.valueOf(Messages.SelectTracesWizardPage_TraceRemovalTask) + " " + tmfTraceElement.getElementPath());
                    keys.remove(name);
                } else {
                    subMonitor.setTaskName(String.valueOf(Messages.SelectTracesWizardPage_TraceSelectionTask) + " " + tmfTraceElement.getElementPath());
                    experimentElement.addTrace(tmfTraceElement, false);
                    changed = true;
                }
                subMonitor.worked(1);
            }
            for (Map.Entry entry : previousTraces.entrySet()) {
                ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                TmfTraceElement trace = (TmfTraceElement)entry.getValue();
                subMonitor.setTaskName(String.valueOf(Messages.SelectTracesWizardPage_TraceRemovalTask) + " " + trace.getElementPath());
                try {
                    experimentElement.removeTrace(trace);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(String.valueOf(Messages.SelectTracesWizardPage_SelectionError) + " " + experimentElement.getName(), e);
                }
                changed = true;
                subMonitor.worked(1);
            }
            if (changed) {
                Display.getDefault().asyncExec(() -> {
                    experimentElement.closeEditors();
                    experimentElement.deleteSupplementaryResources();
                });
            }
            this.setStatus(Status.OK_STATUS);
        }
        catch (InterruptedException interruptedException) {
            this.setStatus(Status.CANCEL_STATUS);
        }
        catch (Exception exception) {
            Activator.getDefault().logError(Messages.SelectTracesWizardPage_SelectionError, exception);
            this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.SelectTracesWizardPage_SelectionError, (Throwable)exception));
        }
    }

    private List<TmfTraceElement> filterTraceElementByTimeRange(List<TmfTraceElement> elements, IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)elements.size());
        ArrayList<TmfTraceElement> filteredElements = new ArrayList<TmfTraceElement>();
        ArrayList<TmfTraceElement> knownBounds = new ArrayList<TmfTraceElement>();
        ConcurrentLinkedQueue<TmfTraceElement> unknownBounds = new ConcurrentLinkedQueue<TmfTraceElement>();
        Iterable traceElements = Iterables.concat(knownBounds, unknownBounds);
        for (TmfTraceElement tmfTraceElement : elements) {
            if (tmfTraceElement.getStartTime() == null || tmfTraceElement.getEndTime() == null) {
                unknownBounds.add(tmfTraceElement);
                continue;
            }
            knownBounds.add(tmfTraceElement);
        }
        if (!unknownBounds.isEmpty()) {
            UpdateTraceBoundsJob job = new UpdateTraceBoundsJob(Messages.SelectTracesWizardPage_UpdateTraceBoundsJobName, new ConcurrentLinkedQueue<TmfTraceElement>(unknownBounds));
            job.run((IProgressMonitor)subMonitor.newChild(1));
        }
        for (TmfTraceElement element : traceElements) {
            if (!this.isInTimeRange(element.getStartTime(), element.getEndTime())) continue;
            filteredElements.add(element);
        }
        return filteredElements;
    }

    private boolean isInTimeRange(ITmfTimestamp traceStartTime, ITmfTimestamp traceEndTime) {
        return traceStartTime.compareTo(this.fEndTimeRange) <= 0 && traceEndTime.compareTo(this.fStartTimeRange) >= 0;
    }

    protected void setStatus(@NonNull IStatus status) {
        this.fStatus = status;
    }

    public @NonNull IStatus getStatus() {
        return this.fStatus;
    }
}

