/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.objectlife;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.objectlife.ObjectLifeAnalysis;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class ObjectLifeDataProvider
extends AbstractTimeGraphDataProvider<ObjectLifeAnalysis, TimeGraphEntryModel> {
    public static final String SUFFIX = ".dataprovider";

    public ObjectLifeDataProvider(ITmfTrace trace, ObjectLifeAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    @Deprecated
    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        return this.fetchArrows(parameters, monitor);
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    @Deprecated
    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
        return this.fetchTooltip(parameters, monitor);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ITmfStateSystem ss = ((ObjectLifeAnalysis)this.getAnalysisModule()).getStateSystem();
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        @NonNull @NonNull Map entries = this.getSelectedEntries(filter);
        Collection<@NonNull V> quarks = entries.values();
        long start = filter.getStart();
        if (ss == null || quarks.size() != 1 || !((ObjectLifeAnalysis)this.getAnalysisModule()).isQueryable(start)) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        int quark = (Integer)quarks.iterator().next();
        try {
            Map<Object, Object> retMap = null;
            ITmfStateInterval state = ss.querySingleState(start, quark);
            Object object = state.getValue();
            retMap = object instanceof String ? Collections.singletonMap("value", object.toString()) : Collections.emptyMap();
            return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        catch (StateSystemDisposedException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
    }

    public @NonNull String getId() {
        return String.valueOf(((ObjectLifeAnalysis)this.getAnalysisModule()).getId()) + SUFFIX;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable TimeGraphModel getRowModel(@NonNull ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(parameters);
        @NonNull @NonNull Map entries = this.getSelectedEntries(filter);
        Collection times = ObjectLifeDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        for (ITmfStateInterval interval : ss.query2D(entries.values(), times)) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        ArrayList<@NonNull TimeGraphRowModel> rows = new ArrayList<TimeGraphRowModel>();
        for (Map.Entry entry : entries.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            ArrayList<TimeGraphState> eventList = new ArrayList<TimeGraphState>();
            for (ITmfStateInterval interval : intervals.get((Object)((Integer)entry.getValue()))) {
                long startTime = interval.getStartTime();
                long duration = interval.getEndTime() - startTime + 1L;
                Object state = interval.getValue();
                TimeGraphState value = state == null ? new TimeGraphState(startTime, duration, Math.max(((Long)entry.getKey()).intValue(), 0)) : new TimeGraphState(startTime, duration, Math.max(((Long)entry.getKey()).intValue(), 0), String.valueOf(state));
                eventList.add(value);
            }
            rows.add(new TimeGraphRowModel(((Long)entry.getKey()).longValue(), eventList));
        }
        return new TimeGraphModel(rows);
    }

    protected boolean isCacheable() {
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull TmfTreeModel<@NonNull TimeGraphEntryModel> getTree(@NonNull ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ImmutableList.Builder builder = new ImmutableList.Builder();
        long parentId = this.getId(-1);
        builder.add((Object)new TimeGraphEntryModel(parentId, -1L, Collections.singletonList(this.getTrace().getName()), ss.getStartTime(), ss.getCurrentEndTime()));
        this.addChildren(ss, (ImmutableList.Builder<TimeGraphEntryModel>)builder, -1, parentId);
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    private void addChildren(ITmfStateSystem ss, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<@NonNull TimeGraphEntryModel> builder, int quark, long parentId) {
        for (Integer child : ss.getSubAttributes(quark, false)) {
            long childId = this.getId(child);
            builder.add((Object)new TimeGraphEntryModel(childId, parentId, Collections.singletonList(ss.getAttributeName(child.intValue())), ss.getStartTime(), ss.getCurrentEndTime()));
            this.addChildren(ss, builder, child, childId);
        }
    }
}

