/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.FusedVMInformationProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.trace.VirtualMachineExperiment;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.Machine;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.Messages;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.Processor;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.VirtualResourceEntry;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class VirtualResourcePresentationProvider
extends TimeGraphPresentationProvider {
    static final float FULL_HEIGHT = 1.0f;
    static final float REDUCED_HEIGHT = 0.25f;
    private long fLastThreadId = -1L;
    private Color fColorWhite;
    private Color fColorGray;
    private Integer fAverageCharWidth;
    private volatile Object selectedFusedVMViewEntry;
    private String selectedMachine;
    private HostThread fSelectedThread;
    private int selectedCpu;
    private String selectedContainer;
    private Map<String, Machine> fHighlightedMachines = new HashMap<String, Machine>();
    private Multimap<String, Processor> fHighlightedCpus = HashMultimap.create();
    private Collection<Object> fSelectedElements = Collections.emptyList();
    private final Map<ITimeEvent, Float> fTimeEventHighlight = new HashMap<ITimeEvent, Float>();

    private static State[] getStateValues() {
        return State.values();
    }

    private static State getEventState(TimeEvent event) {
        if (event.hasValue()) {
            VirtualResourceEntry entry = (VirtualResourceEntry)event.getEntry();
            int value = event.getValue();
            if (entry.getType() == VirtualResourceEntry.Type.CPU || entry.getType() == VirtualResourceEntry.Type.PCPU_VM || entry.getType() == VirtualResourceEntry.Type.PCPU_CONTAINER) {
                State state = null;
                if (value == 0) {
                    state = State.IDLE;
                } else if (value == 2) {
                    state = State.USERMODE;
                } else if (value == 4) {
                    state = State.SYSCALL;
                } else if (value == 16) {
                    state = State.IRQ;
                } else if (value == 8) {
                    state = State.SOFT_IRQ;
                } else if (value == 1) {
                    state = State.SOFT_IRQ_RAISED;
                } else if (value == 32) {
                    state = State.IN_VM;
                }
                if (state != null) {
                    return state;
                }
            } else {
                if (entry.getType() == VirtualResourceEntry.Type.IRQ) {
                    return State.IRQ_ACTIVE;
                }
                if (entry.getType() == VirtualResourceEntry.Type.SOFT_IRQ) {
                    if (value == 1) {
                        return State.SOFT_IRQ_RAISED;
                    }
                    return State.SOFT_IRQ_ACTIVE;
                }
            }
        }
        return null;
    }

    public int getStateTableIndex(ITimeEvent event) {
        State state = VirtualResourcePresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.ordinal();
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -1;
    }

    public StateItem[] getStateTable() {
        State[] states = VirtualResourcePresentationProvider.getStateValues();
        StateItem[] stateTable = new StateItem[states.length];
        int i = 0;
        while (i < stateTable.length) {
            State state = states[i];
            stateTable[i] = new StateItem(state.rgb, state.toString());
            ++i;
        }
        return stateTable;
    }

    public String getEventName(ITimeEvent event) {
        State state = VirtualResourcePresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.toString();
        }
        if (event instanceof NullTimeEvent) {
            return null;
        }
        return Messages.FusedVMView_multipleStates;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        LinkedHashMap<String, String> retMap;
        block28: {
            retMap = new LinkedHashMap<String, String>();
            if (!(event instanceof TimeEvent) || !((TimeEvent)event).hasValue()) {
                return retMap;
            }
            TimeEvent tcEvent = (TimeEvent)event;
            VirtualResourceEntry entry = (VirtualResourceEntry)event.getEntry();
            ITmfTrace exp = entry.getTrace();
            ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)exp, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.FusedVirtualMachineAnalysis");
            if (ss == null) {
                return retMap;
            }
            int cpuQuark = entry.getQuark();
            String machineName = null;
            try {
                int cpu;
                int machineVCpuQuark;
                ITmfStateValue value;
                int condition;
                int conditionQuark;
                ITmfStateInterval interval;
                List fullState = ss.queryFullState(hoverTime);
                int machineNameQuark = ss.optQuarkRelative(cpuQuark, new String[]{"Machine_name"});
                if (machineNameQuark != -2) {
                    interval = (ITmfStateInterval)fullState.get(machineNameQuark);
                    ITmfStateValue value2 = interval.getStateValue();
                    machineName = value2.unboxStr();
                    retMap.put(Messages.FusedVMView_TooltipVirtualMachine, machineName);
                }
                if ((conditionQuark = ss.optQuarkRelative(cpuQuark, new String[]{"Condition"})) != -2 && (condition = (value = (interval = (ITmfStateInterval)fullState.get(conditionQuark)).getStateValue()).unboxInt()) == 0 && (machineVCpuQuark = ss.optQuarkRelative(cpuQuark, new String[]{"Virtual_cpu"})) != -2) {
                    interval = (ITmfStateInterval)fullState.get(machineVCpuQuark);
                    value = interval.getStateValue();
                    int vcpu = value.unboxInt();
                    retMap.put(Messages.FusedVMView_TooltipVirtualCpu, String.valueOf(vcpu));
                }
                if (entry.getType().equals((Object)VirtualResourceEntry.Type.IRQ) || entry.getType().equals((Object)VirtualResourceEntry.Type.SOFT_IRQ)) {
                    int cpu2 = tcEvent.getValue();
                    if (cpu2 >= 0) {
                        retMap.put(Messages.FusedVMView_attributeCpuName, String.valueOf(cpu2));
                    }
                    break block28;
                }
                if (!entry.getType().equals((Object)VirtualResourceEntry.Type.CPU) && !entry.getType().equals((Object)VirtualResourceEntry.Type.PCPU_VM) && !entry.getType().equals((Object)VirtualResourceEntry.Type.PCPU_CONTAINER)) break block28;
                int status = tcEvent.getValue();
                if (status == 16) {
                    cpu = entry.getId();
                    List irqQuarks = ss.getQuarks(new String[]{"CPUs", Integer.toString(cpu), "IRQs", "*"});
                    Iterator iterator = irqQuarks.iterator();
                    while (iterator.hasNext()) {
                        int irqQuark = (Integer)iterator.next();
                        if (((ITmfStateInterval)fullState.get(irqQuark)).getStateValue().unboxInt() != cpu) continue;
                        ITmfStateInterval value3 = (ITmfStateInterval)fullState.get(irqQuark);
                        if (!value3.getStateValue().isNull()) {
                            int irq = Integer.parseInt(ss.getAttributeName(irqQuark));
                            retMap.put(Messages.FusedVMView_attributeIrqName, String.valueOf(irq));
                        }
                        break block28;
                    }
                    break block28;
                }
                if (status == 8) {
                    cpu = entry.getId();
                    List softIrqQuarks = ss.getQuarks(new String[]{"CPUs", Integer.toString(cpu), "Soft_IRQs", "*"});
                    Iterator iterator = softIrqQuarks.iterator();
                    while (iterator.hasNext()) {
                        int softIrqQuark = (Integer)iterator.next();
                        if (((ITmfStateInterval)fullState.get(softIrqQuark)).getStateValue().unboxInt() != cpu) continue;
                        ITmfStateInterval value4 = (ITmfStateInterval)fullState.get(softIrqQuark);
                        if (!value4.getStateValue().isNull()) {
                            int softIrq = Integer.parseInt(ss.getAttributeName(softIrqQuark));
                            retMap.put(Messages.FusedVMView_attributeSoftIrqName, String.valueOf(softIrq));
                        }
                        break block28;
                    }
                    break block28;
                }
                if (status == 2 || status == 4) {
                    retMap.put(Messages.FusedVMView_attributeHoverTime, FormatTimeUtils.formatTime((long)hoverTime, (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.CALENDAR, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC));
                    cpuQuark = entry.getQuark();
                    int currentThreadQuark = ss.optQuarkRelative(cpuQuark, new String[]{"Current_thread"});
                    if (currentThreadQuark == -2) {
                        return retMap;
                    }
                    interval = (ITmfStateInterval)fullState.get(currentThreadQuark);
                    if (!interval.getStateValue().isNull()) {
                        int execNameQuark;
                        int nsMaxLevelQuark;
                        ITmfStateValue value5 = interval.getStateValue();
                        int currentThreadId = value5.unboxInt();
                        retMap.put(Messages.FusedVMView_attributeTidName, Integer.toString(currentThreadId));
                        int saveTID = currentThreadId;
                        if (currentThreadId == 0) {
                            ++currentThreadId;
                        }
                        if ((nsMaxLevelQuark = ss.optQuarkAbsolute(new String[]{"Threads", machineName, Integer.toString(currentThreadId), "ns_max_level"})) == -2) {
                            return retMap;
                        }
                        currentThreadId = saveTID;
                        interval = (ITmfStateInterval)fullState.get(nsMaxLevelQuark);
                        int nsMaxLevel = interval.getStateValue().unboxInt();
                        if (nsMaxLevel > 1) {
                            int actualLevel = 1;
                            int virtualTIDQuark = ss.optQuarkAbsolute(new String[]{"Threads", machineName, Integer.toString(currentThreadId), "VTID"});
                            if (virtualTIDQuark == -2) {
                                return retMap;
                            }
                            ++actualLevel;
                            while (actualLevel < nsMaxLevel) {
                                if ((virtualTIDQuark = ss.optQuarkRelative(virtualTIDQuark, new String[]{"VTID"})) == -2) break;
                                ++actualLevel;
                            }
                            int vtid = ((ITmfStateInterval)fullState.get(virtualTIDQuark)).getStateValue().unboxInt();
                            int namespaceIDQuark = ss.optQuarkRelative(virtualTIDQuark, new String[]{"ns_inum"});
                            if (namespaceIDQuark == -2) {
                                return retMap;
                            }
                            long namespaceID = ((ITmfStateInterval)fullState.get(namespaceIDQuark)).getStateValue().unboxLong();
                            retMap.put(Messages.FusedVMView_TooltipRecVtid, Integer.toString(vtid));
                            retMap.put(Messages.FusedVMView_TooltipRecContainer, Long.toString(namespaceID));
                        }
                        if ((execNameQuark = ss.optQuarkAbsolute(new String[]{"Threads", machineName, Integer.toString(currentThreadId), "Exec_name"})) == -2) {
                            return retMap;
                        }
                        interval = (ITmfStateInterval)fullState.get(execNameQuark);
                        if (!interval.getStateValue().isNull()) {
                            value5 = interval.getStateValue();
                            retMap.put(Messages.FusedVMView_attributeProcessName, value5.unboxStr());
                        }
                        if (status == 4) {
                            int syscallQuark = ss.optQuarkAbsolute(new String[]{"Threads", machineName, Integer.toString(currentThreadId), "System_call"});
                            if (syscallQuark == -2) {
                                return retMap;
                            }
                            interval = (ITmfStateInterval)fullState.get(syscallQuark);
                            if (!interval.getStateValue().isNull()) {
                                value5 = interval.getStateValue();
                                retMap.put(Messages.FusedVMView_attributeSyscallName, value5.unboxStr());
                            }
                        }
                    }
                }
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
        }
        return retMap;
    }

    /*
     * Unable to fully structure code
     */
    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (this.fColorGray == null) {
            this.fColorGray = gc.getDevice().getSystemColor(15);
        }
        if (this.fColorWhite == null) {
            this.fColorWhite = gc.getDevice().getSystemColor(1);
        }
        if (this.fAverageCharWidth == null) {
            this.fAverageCharWidth = gc.getFontMetrics().getAverageCharWidth();
        }
        drawingHelper = this.getDrawingHelper();
        if (bounds.width <= this.fAverageCharWidth) {
            return;
        }
        if (!(event instanceof TimeEvent)) {
            return;
        }
        tcEvent = (TimeEvent)event;
        if (!tcEvent.hasValue()) {
            return;
        }
        entry = (VirtualResourceEntry)event.getEntry();
        if (!(entry.getType().equals((Object)VirtualResourceEntry.Type.CPU) || entry.getType().equals((Object)VirtualResourceEntry.Type.PCPU_VM) || entry.getType().equals((Object)VirtualResourceEntry.Type.PCPU_CONTAINER))) {
            return;
        }
        status = tcEvent.getValue();
        if (status != 2 && status != 4) {
            return;
        }
        exp = entry.getTrace();
        ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)exp, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.FusedVirtualMachineAnalysis");
        if (ss == null) {
            return;
        }
        time = event.getTime();
        cpuQuark = entry.getQuark();
        machineName = null;
        try {
            machineNameQuark = ss.getQuarkRelative(cpuQuark, new String[]{"Machine_name"});
            interval = ss.querySingleState(time, machineNameQuark);
            value = interval.getStateValue();
            machineName = value.unboxStr();
            ** GOTO lbl-1000
        }
        catch (AttributeNotFoundException e) {
            Activator.getDefault().logError("Error in FusedVMViewPresentationProvider, timestamp: " + FusedVMInformationProvider.formatTime((long)event.getTime()), e);
            ** GOTO lbl-1000
        }
        catch (StateSystemDisposedException e) lbl-1000:
        // 3 sources

        {
            try {
                while (time < event.getTime() + event.getDuration()) {
                    cpuQuark = entry.getQuark();
                    currentThreadQuark = ss.getQuarkRelative(cpuQuark, new String[]{"Current_thread"});
                    tidInterval = ss.querySingleState(time, currentThreadQuark);
                    startTime = Math.max(tidInterval.getStartTime(), event.getTime());
                    x = Math.max(drawingHelper.getXForTime(startTime), bounds.x);
                    if (x < bounds.x + bounds.width) {
                        if (!tidInterval.getStateValue().isNull()) {
                            value = tidInterval.getStateValue();
                            currentThreadId = value.unboxInt();
                            endTime = Math.min(tidInterval.getEndTime() + 1L, event.getTime() + event.getDuration());
                            xForEndTime = drawingHelper.getXForTime(endTime);
                            if (xForEndTime > bounds.x && (width = Math.min(xForEndTime, bounds.x + bounds.width) - x - 1) > 0) {
                                attribute = null;
                                beginIndex = 0;
                                if (status == 2 && (long)currentThreadId != this.fLastThreadId) {
                                    attribute = "Exec_name";
                                } else if (status == 4) {
                                    attribute = "System_call";
                                    trace = entry.getTrace();
                                    if (trace instanceof IKernelTrace) {
                                        layout = ((IKernelTrace)trace).getKernelEventLayout();
                                        beginIndex = layout.eventSyscallEntryPrefix().length();
                                    } else if (trace instanceof VirtualMachineExperiment) {
                                        layout = ((IKernelTrace)trace.getChild(0)).getKernelEventLayout();
                                        beginIndex = layout.eventSyscallEntryPrefix().length();
                                    }
                                }
                                if (attribute != null && !(interval = ss.querySingleState(time, quark = ss.getQuarkAbsolute(new String[]{"Threads", machineName, Integer.toString(currentThreadId), attribute}))).getStateValue().isNull()) {
                                    value = interval.getStateValue();
                                    gc.setForeground(this.fColorWhite);
                                    drawn = Utils.drawText((GC)gc, (String)value.unboxStr().substring(beginIndex), (int)(x + 1), (int)(bounds.y - 2), (int)width, (int)bounds.height, (boolean)true, (boolean)true);
                                    if (drawn > 0) {
                                        this.fLastThreadId = currentThreadId;
                                    }
                                }
                                if (xForEndTime < bounds.x + bounds.width) {
                                    gc.setForeground(this.fColorGray);
                                    gc.drawLine(xForEndTime, bounds.y + 1, xForEndTime, bounds.y + bounds.height - 2);
                                }
                            }
                        }
                        time = Math.max(tidInterval.getEndTime() + 1L, drawingHelper.getTimeAtX(x + 1));
                    }
                }
            }
            catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                Activator.getDefault().logError("Error in FusedVMViewPresentationProvider, timestamp: " + FusedVMInformationProvider.formatTime((long)event.getTime()), e);
            }
            catch (StateSystemDisposedException var14_20) {
                // empty catch block
            }
        }
    }

    public void postDrawEntry(ITimeGraphEntry entry, Rectangle bounds, GC gc) {
        this.fLastThreadId = -1L;
    }

    private boolean isMachineAndCpuHighlighted(ITimeEvent event) throws StateSystemDisposedException {
        Map<String, Machine> map = this.getHighlightedMachines();
        if (map.isEmpty()) {
            return this.fSelectedThread == null;
        }
        VirtualResourceEntry entry = (VirtualResourceEntry)event.getEntry();
        ITmfTrace trace = entry.getTrace();
        ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.FusedVirtualMachineAnalysis");
        int cpuQuark = entry.getQuark();
        long time = event.getTime() + event.getDuration() - 1L;
        if (ss == null) {
            return false;
        }
        List allMachines = FusedVMInformationProvider.getAllMachines((ITmfStateSystem)ss, (int)Integer.valueOf(ss.getAttributeName(cpuQuark)), (long)time);
        allMachines.retainAll(map.keySet());
        for (String machineName : allMachines) {
            Machine highlighted = map.get(machineName);
            Collection<Processor> highlightedCpus = this.getHighlightedCpusFor(machineName);
            if (highlighted != null && highlightedCpus.isEmpty()) {
                return true;
            }
            int conditionQuark = ss.optQuarkRelative(cpuQuark, new String[]{"Condition"});
            if (conditionQuark == -2) {
                return false;
            }
            ITmfStateInterval interval = ss.querySingleState(time, conditionQuark);
            if (interval.getStateValue().isNull()) continue;
            ITmfStateValue valueInVM = interval.getStateValue();
            int cpu = -1;
            int inVM = valueInVM.unboxInt();
            switch (inVM) {
                case 0: {
                    int machineVCpuQuark = ss.optQuarkRelative(cpuQuark, new String[]{"Virtual_cpu"});
                    if (machineVCpuQuark == -2) {
                        return false;
                    }
                    interval = ss.querySingleState(time, machineVCpuQuark);
                    ITmfStateValue value = interval.getStateValue();
                    cpu = value.unboxInt();
                    break;
                }
                case 1: {
                    cpu = Integer.parseInt(ss.getAttributeName(cpuQuark));
                    break;
                }
                default: {
                    return true;
                }
            }
            if (cpu == -1) continue;
            for (Processor proc : highlightedCpus) {
                if (proc.getNumber() != cpu) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isProcessHighlighted(ITimeEvent event) throws StateSystemDisposedException {
        HostThread selectedThread = this.fSelectedThread;
        if (selectedThread == null) {
            return false;
        }
        VirtualResourceEntry entry = (VirtualResourceEntry)event.getEntry();
        ITmfTrace trace = entry.getTrace();
        ITmfStateSystem ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.FusedVirtualMachineAnalysis");
        int cpuQuark = entry.getQuark();
        long time = event.getTime();
        if (ss == null) {
            return false;
        }
        int machineHostQuark = ss.optQuarkRelative(cpuQuark, new String[]{"Machine_name"});
        int currentThreadQuark = ss.optQuarkRelative(cpuQuark, new String[]{"Current_thread"});
        if (machineHostQuark == -2 || currentThreadQuark == -2) {
            return false;
        }
        ITmfStateInterval interval = ss.querySingleState(time, machineHostQuark);
        ITmfStateValue value = interval.getStateValue();
        String machineHost = value.unboxStr();
        interval = ss.querySingleState(time, currentThreadQuark);
        value = interval.getStateValue();
        int currentThreadID = value.unboxInt();
        return selectedThread.equals((Object)new HostThread(machineHost, Integer.valueOf(currentThreadID)));
    }

    public void setSelectedFusedVMViewEntry(Object o) {
        this.selectedFusedVMViewEntry = o;
    }

    public Object getSelectedFusedVMViewEntry() {
        return this.selectedFusedVMViewEntry;
    }

    public String getSelectedMachine() {
        return this.selectedMachine;
    }

    public void setSelectedMachine(String machine) {
        this.selectedMachine = machine;
    }

    public int getSelectedCpu() {
        return this.selectedCpu;
    }

    public void setSelectedCpu(int cpu) {
        this.selectedCpu = cpu;
    }

    public void setSelectedThread(@Nullable HostThread ht) {
        HostThread selectedThread;
        this.fSelectedThread = ht == null ? null : (ht.equals((Object)(selectedThread = this.fSelectedThread)) ? null : ht);
        this.resetTimeEventHighlight();
    }

    public void setSelectedContainer(String container) {
        this.selectedContainer = container;
    }

    public String getSelectedContainer() {
        return this.selectedContainer;
    }

    private Map<String, Machine> getHighlightedMachines() {
        return this.fHighlightedMachines;
    }

    private Collection<Processor> getHighlightedCpusFor(String machine) {
        return this.fHighlightedCpus.get((Object)machine);
    }

    public void resetTimeEventHighlight() {
        this.fTimeEventHighlight.clear();
    }

    public Map<String, Object> getSpecificEventStyle(ITimeEvent event) {
        float heightFactor = 1.0f;
        Float b = this.fTimeEventHighlight.get(event);
        if (b != null) {
            return ImmutableMap.of((Object)ITimeEventStyleStrings.heightFactor(), (Object)b);
        }
        try {
            VirtualResourceEntry.Type typeEntry = ((VirtualResourceEntry)event.getEntry()).getType();
            heightFactor = typeEntry == VirtualResourceEntry.Type.IRQ || typeEntry == VirtualResourceEntry.Type.SOFT_IRQ ? 1.0f : (this.isProcessHighlighted(event) || this.isMachineAndCpuHighlighted(event) ? 1.0f : 0.25f);
        }
        catch (StateSystemDisposedException e) {
            heightFactor = 1.0f;
        }
        this.fTimeEventHighlight.put(event, Float.valueOf(heightFactor));
        return ImmutableMap.of((Object)ITimeEventStyleStrings.heightFactor(), (Object)Float.valueOf(heightFactor));
    }

    public void modifySelectedThreadAlpha(int delta) {
    }

    Collection<Object> getSelectedElements() {
        return this.fSelectedElements;
    }

    void setSelectedElements(Collection<Object> elements) {
        this.fSelectedElements = elements;
        this.fHighlightedMachines.clear();
        this.fHighlightedCpus.clear();
        for (Object obj : elements) {
            if (obj instanceof Machine) {
                Machine machine = (Machine)obj;
                this.fHighlightedMachines.put(machine.isContainer() ? machine.getMachineName() : machine.getHostId(), machine);
                continue;
            }
            if (!(obj instanceof Processor)) continue;
            Processor processor = (Processor)obj;
            Machine machine = processor.getMachine();
            this.fHighlightedCpus.put((Object)(machine.isContainer() ? machine.getMachineName() : machine.getHostId()), (Object)processor);
        }
    }

    private static enum State {
        IDLE(new RGB(200, 200, 200)),
        USERMODE(new RGB(0, 200, 0)),
        SYSCALL(new RGB(0, 0, 200)),
        IRQ(new RGB(200, 0, 100)),
        SOFT_IRQ(new RGB(200, 150, 100)),
        IRQ_ACTIVE(new RGB(200, 0, 100)),
        SOFT_IRQ_RAISED(new RGB(200, 200, 0)),
        SOFT_IRQ_ACTIVE(new RGB(200, 150, 100)),
        IN_VM(new RGB(200, 0, 200));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

