/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTree;

public class DifferentialWeightedTreeProvider
implements IWeightedTreeProvider<Object, String, DifferentialWeightedTree<Object>> {
    private static final String DEFAULT_ELEMENT = "diff";
    private static final Format FORMAT = new DecimalFormat("#.#");
    private static final Format DIFFERENTIAL_FORMAT = new Format(){
        private static final long serialVersionUID = 1L;

        @Override
        public @Nullable StringBuffer format(@Nullable Object obj, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
            StringBuffer buf = toAppendTo;
            if (buf == null) {
                buf = new StringBuffer();
            }
            if (obj instanceof Number) {
                double num = ((Number)obj).doubleValue();
                if (num == 0.0) {
                    return buf.append("No Difference");
                }
                return buf.append(num > 0.0 ? "+" : "").append(FORMAT.format(num * 100.0)).append("%");
            }
            return FORMAT.format(obj, toAppendTo, pos);
        }

        @Override
        public @Nullable Object parseObject(@Nullable String source, @Nullable ParsePosition pos) {
            return null;
        }
    };
    private static final List<IWeightedTreeProvider.MetricType> WEIGHT_TYPES = Collections.singletonList(new IWeightedTreeProvider.MetricType("Differential", IWeightedTreeProvider.DataType.OTHER, DIFFERENTIAL_FORMAT));
    private final Collection<DifferentialWeightedTree<Object>> fTrees;
    private final IWeightedTreeProvider<Object, ?, WeightedTree<Object>> fOriginalTree;

    public DifferentialWeightedTreeProvider(IWeightedTreeProvider<Object, ?, WeightedTree<Object>> originalTree, Collection<DifferentialWeightedTree<Object>> trees) {
        this.fTrees = trees;
        this.fOriginalTree = originalTree;
    }

    @Override
    public Collection<DifferentialWeightedTree<Object>> getTreesFor(String element) {
        if (element.equals(DEFAULT_ELEMENT)) {
            return this.fTrees;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getElements() {
        return Collections.singleton(DEFAULT_ELEMENT);
    }

    @Override
    public String getTitle() {
        return "Differential tree";
    }

    @Override
    public @NonNull IWeightedTreeProvider.MetricType getWeightType() {
        return this.fOriginalTree.getWeightType();
    }

    @Override
    public String toDisplayString(DifferentialWeightedTree<Object> tree) {
        return this.fOriginalTree.toDisplayString(tree.getOriginalTree());
    }

    @Override
    public List<IWeightedTreeProvider.MetricType> getAdditionalMetrics() {
        return WEIGHT_TYPES;
    }

    @Override
    public Object getAdditionalMetric(DifferentialWeightedTree<Object> object, int metricIndex) {
        if (metricIndex == 0) {
            return object.getDifference();
        }
        return "";
    }
}

