/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.xychart;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.XmlViewInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.xychart.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.xychart.XmlTreeViewer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.xychart.XmlXYViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;
import org.eclipse.tracecompass.tmf.ui.views.TmfViewFactory;
import org.w3c.dom.Element;

public class XmlXYView
extends TmfChartView {
    public static final String ID = "org.eclipse.linuxtools.internal.tmf.analysis.xml.ui.views.xyview";
    private final XmlViewInfo fViewInfo = new XmlViewInfo("org.eclipse.linuxtools.internal.tmf.analysis.xml.ui.views.xyview");

    public XmlXYView() {
        super(Messages.XmlXYView_DefaultTitle);
        this.addPartPropertyListener(event -> {
            Object newValue;
            if (event == null) {
                return;
            }
            if (event.getProperty().equals("xmlOutputData") && (newValue = event.getNewValue()) instanceof String) {
                TmfXYChartViewer chart;
                this.fViewInfo.setViewData((String)newValue);
                this.setViewTitle();
                TmfViewer left = this.getLeftChildViewer();
                if (left instanceof XmlTreeViewer) {
                    ((XmlTreeViewer)left).reset();
                }
                if ((chart = this.getChartViewer()) instanceof XmlXYViewer) {
                    ((XmlXYViewer)chart).reset();
                }
                this.loadTrace();
            }
        });
    }

    private void setViewTitle() {
        Element viewElement = this.fViewInfo.getViewElement("xyView");
        if (viewElement == null) {
            return;
        }
        String title = this.fViewInfo.getViewTitle(viewElement);
        Display.getDefault().asyncExec(() -> this.setPartName(title != null ? title : Messages.XmlXYView_DefaultTitle));
    }

    public void createPartControl(@Nullable Composite parent) {
        String name = this.getViewSite().getSecondaryId();
        if (name != null) {
            name = TmfViewFactory.getBaseSecId((String)name);
        }
        if (name != null) {
            this.fViewInfo.setName(name);
        }
        super.createPartControl(parent);
        this.setViewTitle();
    }

    protected TmfXYChartViewer createChartViewer(@Nullable Composite parent) {
        TmfXYChartSettings settings = new TmfXYChartSettings(Messages.XmlXYViewer_DefaultViewerTitle, Messages.XmlXYViewer_DefaultXAxis, Messages.XmlXYViewer_DefaultYAxis, 1.0);
        return new XmlXYViewer(parent, settings, this.fViewInfo);
    }

    protected @NonNull TmfViewer createLeftChildViewer(@Nullable Composite parent) {
        return new XmlTreeViewer(Objects.requireNonNull(parent), this.fViewInfo);
    }
}

