/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.filter.model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAspectNode;

public class TmfFilterMatchesNode
extends TmfFilterAspectNode {
    public static final String NODE_NAME = "MATCHES";
    @Deprecated
    public static final String NOT_ATTR = "not";
    public static final String REGEX_ATTR = "regex";
    private String fRegex;
    private transient Pattern fPattern;

    public TmfFilterMatchesNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public String getRegex() {
        return this.fRegex;
    }

    public void setRegex(String regex) {
        this.fRegex = regex;
        if (regex != null) {
            try {
                this.fPattern = Pattern.compile(regex, 32);
            }
            catch (PatternSyntaxException e) {
                this.fPattern = null;
            }
        }
    }

    protected Pattern getPattern() {
        return this.fPattern;
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        Pattern pattern = this.getPattern();
        boolean isNot = this.isNot();
        if (pattern == null || event == null || this.fEventAspect == null) {
            return isNot;
        }
        Object value = this.fEventAspect.resolve(event);
        if (value == null) {
            return isNot;
        }
        return pattern.matcher(value.toString()).find() ^ isNot;
    }

    @Override
    public List<String> getValidChildren() {
        return new ArrayList<String>(0);
    }

    @Override
    public ITmfFilterTreeNode clone() {
        TmfFilterMatchesNode clone = (TmfFilterMatchesNode)super.clone();
        clone.setRegex(this.fRegex);
        return clone;
    }

    @Override
    public String toString(boolean explicit) {
        return String.valueOf(this.getAspectLabel(explicit)) + (this.isNot() ? " not matches \"" : " matches \"") + this.getRegex() + '\"';
    }
}

