/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.virtual.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis.VirtualMachineModelAnalysis;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.virtual.resources.Messages;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.virtual.resources.VirtualResourcesStateProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperimentUtils;

public class VirtualResourcesAnalysis
extends TmfStateSystemAnalysisModule {
    public static final String ID = "org.eclipse.tracecompass.incubator.virtual.machine.analysis.core.VirtualResourcesAnalysis";
    static final Set<String> REQUIRED_EVENTS = ImmutableSet.of();
    private static final ITmfStateValue VCPU_PREEMPT_VALUE = TmfStateValue.newValueInt((int)256);

    protected ITmfStateProvider createStateProvider() {
        ITmfTrace trace = this.getTrace();
        if (!(trace instanceof TmfExperiment)) {
            throw new IllegalStateException("The trace should be an experiment");
        }
        VirtualMachineModelAnalysis model = (VirtualMachineModelAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, VirtualMachineModelAnalysis.class, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.core.model.analysis");
        if (model == null) {
            throw new IllegalStateException("There should be a model analysis for this class");
        }
        model.schedule();
        if (!model.waitForInitialization()) {
            throw new IllegalStateException("Problem initializing the model analysis");
        }
        return new VirtualResourcesStateProvider((TmfExperiment)trace, model.getVirtualEnvironmentModel());
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
    }

    public String getHelpText() {
        return Messages.getMessage(Messages.VirtualMachineCPUAnalysis_Help);
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        ITmfTrace exp = this.getTrace();
        if (exp instanceof TmfExperiment) {
            VirtualMachineModelAnalysis model = (VirtualMachineModelAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)exp, VirtualMachineModelAnalysis.class, (String)"org.eclipse.tracecompass.incubator.virtual.machine.analysis.core.model.analysis");
            if (model == null) {
                throw new IllegalStateException("There should be a model analysis for this class");
            }
            return Collections.singleton(model);
        }
        return Collections.emptySet();
    }

    private static Multimap<Integer, ITmfStateInterval> createThreadMultimap() {
        TreeMultimap map = TreeMultimap.create(Comparator.naturalOrder(), (arg0, arg1) -> {
            if (arg1.getStateValue() == VCPU_PREEMPT_VALUE && arg0.getStateValue() != VCPU_PREEMPT_VALUE) {
                if (Long.valueOf(arg0.getEndTime()).compareTo(arg1.getStartTime()) < 0) {
                    return -1;
                }
                return Long.valueOf(arg0.getStartTime()).compareTo(arg1.getEndTime());
            }
            return Long.valueOf(arg0.getStartTime()).compareTo(arg1.getStartTime());
        });
        return map;
    }

    public Multimap<Integer, ITmfStateInterval> getUpdatedThreadIntervals(int vmQuark, long start, long end, long resolution, IProgressMonitor monitor) {
        Multimap<Integer, ITmfStateInterval> map = VirtualResourcesAnalysis.createThreadMultimap();
        ITmfStateSystem ss = this.getStateSystem();
        if (ss == null) {
            return map;
        }
        ITmfTrace trace = this.getTrace();
        if (!(trace instanceof TmfExperiment)) {
            return map;
        }
        String vmHostId = ss.getAttributeName(vmQuark);
        KernelAnalysisModule kernelModule = (KernelAnalysisModule)TmfExperimentUtils.getAnalysisModuleOfClassForHost((TmfExperiment)((TmfExperiment)trace), (String)vmHostId, KernelAnalysisModule.class);
        if (kernelModule == null) {
            return map;
        }
        for (Integer tid : KernelThreadInformationProvider.getThreadIds((KernelAnalysisModule)kernelModule)) {
            map.putAll((Object)tid, (Iterable)KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)kernelModule, (Integer)tid, (long)start, (long)end, (long)resolution, (IProgressMonitor)monitor));
            if (!monitor.isCanceled()) continue;
            return map;
        }
        try {
            for (Integer vcpuQuark : ss.getSubAttributes(vmQuark, false)) {
                Long virtualCPU = Long.parseLong(ss.getAttributeName(vcpuQuark.intValue()));
                Integer statusQuark = ss.getQuarkRelative(vcpuQuark.intValue(), new String[]{"Status"});
                for (ITmfStateInterval cpuInterval : StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)statusQuark, (long)start, (long)(end - 1L), (long)resolution, (IProgressMonitor)monitor)) {
                    Integer threadOnCpu;
                    int value;
                    ITmfStateValue stateValue = cpuInterval.getStateValue();
                    if (stateValue.getType() != ITmfStateValue.Type.INTEGER || ((value = stateValue.unboxInt()) & 0x180) == 0 || (threadOnCpu = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)kernelModule, (long)virtualCPU, (long)cpuInterval.getStartTime())) == null) continue;
                    map.put((Object)threadOnCpu, (Object)new TmfStateInterval(cpuInterval.getStartTime(), cpuInterval.getEndTime(), threadOnCpu.intValue(), (Object)256));
                }
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {}
        return map;
    }
}

