/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers;

import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.RocmCallStackStateProvider;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.AbstractGpuEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.HostThreadIdentifier;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public class HsaKernelEventHandler
extends AbstractGpuEventHandler {
    public HsaKernelEventHandler(RocmCallStackStateProvider stateProvider) {
        super(stateProvider);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ssb, ITmfEvent event) throws AttributeNotFoundException {
        String kernelName = (String)event.getContent().getFieldValue(String.class, new String[]{"kernel_name"});
        Long queueId = (Long)event.getContent().getFieldValue(Long.class, new String[]{"queue_id"});
        Long gpuId = (Long)event.getContent().getFieldValue(Long.class, new String[]{"gpu_id"});
        if (queueId == null || gpuId == null) {
            return;
        }
        int gpuQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Processes", "GPU " + gpuId.toString()});
        int queuesQuark = ssb.getQuarkRelativeAndAdd(gpuQuark, new String[]{"Queues"});
        int queueQuark = ssb.getQuarkRelativeAndAdd(queuesQuark, new String[]{"Queue " + Long.toString(queueId)});
        int callStackQuark = ssb.getQuarkRelativeAndAdd(queueQuark, new String[]{"CallStack"});
        Long timestamp = event.getTimestamp().toNanos();
        Long timestampEnd = (Long)event.getContent().getFieldValue(Long.class, new String[]{"complete_time"});
        if (timestampEnd != null) {
            timestampEnd = ((CtfTmfTrace)event.getTrace()).timestampCyclesToNanos(timestampEnd.longValue());
            this.pushParallelActivityOnCallStack(ssb, callStackQuark, kernelName, timestamp, timestampEnd);
        }
        HostThreadIdentifier queueHostThreadIdentifier = new HostThreadIdentifier(queueId.intValue(), HostThreadIdentifier.KERNEL_CATEGORY.QUEUE, gpuId.intValue());
        this.addHostIdToStateSystemIfNotDefined(ssb, event.getTrace(), queueHostThreadIdentifier, callStackQuark);
    }
}

