/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.parser;

import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredType;

public class RecoveredField
extends RecoveredElement {
    public FieldDeclaration fieldDeclaration;
    boolean alreadyCompletedFieldInitialization;
    public RecoveredType[] anonymousTypes;
    public int anonymousTypeCount;

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement parent, int bracketBalance) {
        this(fieldDeclaration, parent, bracketBalance, null);
    }

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement parent, int bracketBalance, Parser parser) {
        super(parent, bracketBalance, parser);
        this.fieldDeclaration = fieldDeclaration;
        this.alreadyCompletedFieldInitialization = fieldDeclaration.initialization != null;
    }

    @Override
    public RecoveredElement add(Statement statement, int bracketBalanceValue) {
        if (this.alreadyCompletedFieldInitialization || !(statement instanceof Expression)) {
            return super.add(statement, bracketBalanceValue);
        }
        this.alreadyCompletedFieldInitialization = true;
        this.fieldDeclaration.initialization = (Expression)statement;
        this.fieldDeclaration.declarationSourceEnd = statement.sourceEnd;
        this.fieldDeclaration.declarationEnd = statement.sourceEnd;
        return this;
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int bracketBalanceValue) {
        if (this.alreadyCompletedFieldInitialization || (typeDeclaration.bits & 0x200) == 0 || this.fieldDeclaration.declarationSourceEnd != 0 && typeDeclaration.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            return super.add(typeDeclaration, bracketBalanceValue);
        }
        if (this.anonymousTypes == null) {
            this.anonymousTypes = new RecoveredType[5];
            this.anonymousTypeCount = 0;
        } else if (this.anonymousTypeCount == this.anonymousTypes.length) {
            this.anonymousTypes = new RecoveredType[2 * this.anonymousTypeCount];
            System.arraycopy(this.anonymousTypes, 0, this.anonymousTypes, 0, this.anonymousTypeCount);
        }
        RecoveredType element = new RecoveredType(typeDeclaration, (RecoveredElement)this, bracketBalanceValue);
        this.anonymousTypes[this.anonymousTypeCount++] = element;
        return element;
    }

    @Override
    public ASTNode parseTree() {
        return this.fieldDeclaration;
    }

    @Override
    public int sourceEnd() {
        return this.fieldDeclaration.declarationSourceEnd;
    }

    @Override
    public String toString(int tab) {
        StringBuffer buffer = new StringBuffer(this.tabString(tab));
        buffer.append("Recovered field:\n");
        this.fieldDeclaration.print(tab + 1, buffer);
        if (this.anonymousTypes != null) {
            int i = 0;
            while (i < this.anonymousTypeCount) {
                buffer.append("\n");
                buffer.append(this.anonymousTypes[i].toString(tab + 1));
                ++i;
            }
        }
        return buffer.toString();
    }

    public FieldDeclaration updatedFieldDeclaration() {
        if (this.anonymousTypes != null && this.fieldDeclaration.initialization == null) {
            int i = 0;
            while (i < this.anonymousTypeCount) {
                RecoveredType recoveredType = this.anonymousTypes[i];
                TypeDeclaration typeDeclaration = recoveredType.typeDeclaration;
                if (typeDeclaration.declarationSourceEnd == 0) {
                    typeDeclaration.declarationSourceEnd = this.fieldDeclaration.declarationSourceEnd;
                    typeDeclaration.bodyEnd = this.fieldDeclaration.declarationSourceEnd;
                }
                if (recoveredType.preserveContent) {
                    TypeDeclaration anonymousType = recoveredType.updatedTypeDeclaration();
                    this.fieldDeclaration.initialization = anonymousType.allocation;
                    if (this.fieldDeclaration.declarationSourceEnd == 0) {
                        int end;
                        this.fieldDeclaration.declarationSourceEnd = end = anonymousType.declarationSourceEnd;
                        this.fieldDeclaration.declarationEnd = end;
                    }
                }
                ++i;
            }
            if (this.anonymousTypeCount > 0) {
                this.fieldDeclaration.bits |= 2;
            }
        }
        return this.fieldDeclaration;
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int braceStart, int braceEnd) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                this.alreadyCompletedFieldInitialization = true;
            }
            return this;
        }
        if (this.bracketBalance == 0) {
            this.alreadyCompletedFieldInitialization = true;
            this.updateSourceEndIfNecessary(braceEnd - 1);
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(braceStart, braceEnd);
        }
        return this;
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int braceStart, int braceEnd) {
        if (this.fieldDeclaration.declarationSourceEnd == 0 && (this.fieldDeclaration.type instanceof ArrayTypeReference || this.fieldDeclaration.type instanceof ArrayQualifiedTypeReference) && !this.alreadyCompletedFieldInitialization) {
            ++this.bracketBalance;
            return null;
        }
        this.updateSourceEndIfNecessary(braceStart - 1, braceEnd - 1);
        return this.parent.updateOnOpeningBrace(braceStart, braceEnd);
    }

    @Override
    public void updateParseTree() {
        this.updatedFieldDeclaration();
    }

    @Override
    public void updateSourceEndIfNecessary(int bodyStart, int bodyEnd) {
        if (this.fieldDeclaration.declarationSourceEnd == 0) {
            this.fieldDeclaration.declarationSourceEnd = bodyEnd;
            this.fieldDeclaration.declarationEnd = bodyEnd;
        }
    }

    @Override
    public ProgramElement updatedASTNode() {
        return this.updatedFieldDeclaration();
    }
}

