/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.atrace.event;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.atrace.event.IAtraceConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;

@NonNullByDefault
public class SystraceProcessDumpEventField
extends TmfEventField {
    private @Nullable Integer fPpid;
    private @Nullable Integer fPid;

    public SystraceProcessDumpEventField(String name, @Nullable Integer pid, @Nullable Integer pPid, Map<String, Object> fields) {
        super(name, fields, (ITmfEventField[])fields.entrySet().stream().map(entry -> new TmfEventField((String)entry.getKey(), entry.getValue(), null)).toArray(ITmfEventField[]::new));
        this.fPid = pid;
        this.fPpid = pPid;
    }

    public static @Nullable SystraceProcessDumpEventField parseLine(@Nullable String line) {
        if (line == null) {
            return null;
        }
        Matcher matcher = IAtraceConstants.PROCESS_DUMP_PATTERN.matcher(line);
        if (matcher.matches()) {
            String processName = matcher.group("name");
            Integer fPid = Integer.parseInt(matcher.group("pid"));
            Integer fPpid = Integer.parseInt(matcher.group("ppid"));
            HashMap<@NonNull String, @NonNull Object> fields = new HashMap<String, Object>();
            fields.put("name", String.valueOf(processName));
            fields.put("pid", Long.valueOf(fPid.intValue()));
            fields.put("ppid", Long.valueOf(fPpid.intValue()));
            fields.put("tid", Long.valueOf(fPid.intValue()));
            fields.put("status", 2L);
            return new SystraceProcessDumpEventField("ftrace_process_dump", fPid, fPpid, fields);
        }
        return null;
    }

    public @Nullable Integer getPpid() {
        return this.fPpid;
    }

    public void setPpid(Integer Ppid) {
        this.fPpid = Ppid;
    }

    public @Nullable Integer getPid() {
        return this.fPid;
    }

    public void setPid(Integer pid) {
        this.fPid = pid;
    }
}

