/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.help.search.ISearchEngine;
import org.eclipse.help.search.ISearchScope;
import org.eclipse.help.ui.IEngineDescriptor;
import org.eclipse.help.ui.RootScopePage;
import org.eclipse.help.ui.internal.views.EngineDescriptorManager;
import org.eclipse.help.ui.internal.views.EngineTypeDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class EngineDescriptor
implements IEngineDescriptor {
    public static final String P_MASTER = "__enabled__";
    private ISearchEngine engine;
    private IConfigurationElement config;
    private EngineDescriptorManager manager;
    private EngineTypeDescriptor etdesc;
    private Hashtable<String, Object> parameters;
    private String id;
    private String label;
    private String desc;
    private boolean userDefined;

    public EngineDescriptor(IConfigurationElement config) {
        this.config = config;
    }

    public EngineDescriptor(EngineDescriptorManager manager) {
        this.manager = manager;
    }

    public void setEngineType(EngineTypeDescriptor etdesc) {
        this.etdesc = etdesc;
    }

    public void setEngineDescriptorManager(EngineDescriptorManager manager) {
        this.manager = manager;
    }

    public IConfigurationElement getConfig() {
        return this.config;
    }

    @Override
    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        String clabel = null;
        if (this.config != null) {
            clabel = this.config.getAttribute("label");
        }
        if (clabel == null) {
            clabel = this.etdesc.getLabel();
        }
        return clabel;
    }

    @Override
    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        return this.config.getAttribute("id");
    }

    @Override
    public String getEngineTypeId() {
        if (this.etdesc != null) {
            return this.etdesc.getId();
        }
        return this.config.getAttribute("engineTypeId");
    }

    public boolean isEnabled() {
        if (this.userDefined) {
            return true;
        }
        String aenabled = this.config.getAttribute("enabled");
        if (aenabled != null) {
            return aenabled.equals("true");
        }
        return false;
    }

    public Image getIconImage() {
        return this.etdesc.getIconImage();
    }

    @Override
    public String getDescription() {
        IConfigurationElement[] children;
        if (this.desc != null) {
            return this.desc;
        }
        String cdesc = null;
        if (this.config != null && (children = this.config.getChildren("description")).length == 1) {
            cdesc = children[0].getValue();
        }
        if (cdesc == null) {
            return this.etdesc.getDescription();
        }
        return cdesc;
    }

    public IConfigurationElement[] getPages() {
        return this.etdesc.getPages();
    }

    public ImageDescriptor getImageDescriptor() {
        return this.etdesc.getImageDescriptor();
    }

    public RootScopePage createRootPage(String scopeSetName) {
        RootScopePage page = this.etdesc.createRootPage(scopeSetName);
        if (page != null) {
            page.init(this, scopeSetName);
        }
        return page;
    }

    @Override
    public Dictionary<String, Object> getParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        this.parameters = new Hashtable();
        this.parameters.put(P_MASTER, this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
        if (this.config != null) {
            IConfigurationElement[] params = this.config.getChildren("param");
            int i = 0;
            while (i < params.length) {
                IConfigurationElement param = params[i];
                String name = param.getAttribute("name");
                String value = param.getAttribute("value");
                if (name != null && value != null) {
                    this.parameters.put(name, value);
                }
                ++i;
            }
        }
        return this.parameters;
    }

    public ISearchEngine getEngine() {
        if (this.engine == null) {
            this.engine = this.etdesc.createEngine();
        }
        return this.engine;
    }

    public ISearchScope createSearchScope(IPreferenceStore store) {
        return this.etdesc.createSearchScope(store, this.getId(), this.getParameters());
    }

    void setId(String id) {
        this.id = id;
    }

    @Override
    public void setLabel(String label) {
        if (this.isUserDefined()) {
            this.label = label;
            if (this.manager != null) {
                this.manager.notifyPropertyChange(this);
            }
        }
    }

    @Override
    public void setDescription(String desc) {
        if (this.isUserDefined()) {
            this.desc = desc;
            if (this.manager != null) {
                this.manager.notifyPropertyChange(this);
            }
        }
    }

    @Override
    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }
}

