/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis;

import java.text.DecimalFormat;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;

public class PeriodState
extends TimeGraphState {
    private static final String FORMAT = "#.####";
    private static final DecimalFormat FORMATTER = new DecimalFormat("#.####");
    private static final String TIME_RESOLUTION = "s";
    private final long fPeriod;

    public PeriodState(long time, long duration, long period) {
        super(time, duration, 0, PeriodState.formatNanosecondstoSeconds(period));
        this.fPeriod = period;
    }

    public long getPeriod() {
        return this.fPeriod;
    }

    private static @NonNull String formatNanosecondstoSeconds(long ns) {
        return Objects.requireNonNull(String.valueOf(FORMATTER.format((double)ns / 1.0E9)) + " " + TIME_RESOLUTION);
    }
}

