/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.core;

import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.eclipse.wst.xml.core.internal.validation.AnnotationMsg;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;

public abstract class AbstractNestedValidator
extends AbstractValidator
implements IValidatorJob {
    private static final String REFERENCED_FILE_ERROR_OPEN = "referencedFileError(";
    private static final String REFERENCED_FILE_ERROR_CLOSE = ")";
    private static final String FILE_PROTOCOL_NO_SLASH = "file:";
    private static final String FILE_PROTOCOL = "file:///";
    private final String GET_FILE = "getFile";
    private final String GET_PROJECT_FILES = "getAllFiles";
    private final String GET_INPUTSTREAM = "inputStream";
    protected static final String COLUMN_NUMBER_ATTRIBUTE = "columnNumber";
    protected static final String SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = "squiggleSelectionStrategy";
    protected static final String SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = "squiggleNameOrValue";

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult result = new ValidationResult();
        IFile file = null;
        if (resource instanceof IFile) {
            file = (IFile)resource;
        }
        if (file != null && AbstractNestedValidator.shouldValidate(file)) {
            IReporter reporter = result.getReporter(monitor);
            NestedValidatorContext nestedcontext = this.getNestedContext(state, false);
            boolean teardownRequired = false;
            if (nestedcontext == null) {
                nestedcontext = this.getNestedContext(state, true);
                nestedcontext.setProject(file.getProject());
                this.setupValidation(nestedcontext);
                teardownRequired = true;
            } else {
                nestedcontext.setProject(file.getProject());
            }
            this.validate(file, null, result, reporter, nestedcontext);
            if (teardownRequired) {
                this.teardownValidation(nestedcontext);
            }
        }
        return result;
    }

    public IStatus validateInJob(IValidationContext context, IReporter reporter) throws ValidationException {
        NestedValidatorContext nestedcontext = new NestedValidatorContext();
        this.setupValidation(nestedcontext);
        String[] fileURIs = context.getURIs();
        if (fileURIs != null && fileURIs.length > 0) {
            int numFiles = fileURIs.length;
            int i = 0;
            while (i < numFiles && !reporter.isCancelled()) {
                Object[] parms;
                IFile file;
                String fileName = fileURIs[i];
                if (fileName != null && (file = (IFile)context.loadModel("getFile", parms = new Object[]{fileName})) != null && AbstractNestedValidator.shouldValidate(file)) {
                    nestedcontext.setProject(file.getProject());
                    if (context.loadModel("inputStream") instanceof InputStream) {
                        this.validate(file, (InputStream)context.loadModel("inputStream"), null, reporter, nestedcontext);
                    } else {
                        this.validate(file, null, null, reporter, nestedcontext);
                    }
                }
                ++i;
            }
        } else {
            Object[] parms = new Object[]{this.getValidatorID()};
            Collection files = (Collection)context.loadModel("getAllFiles", parms);
            if (files != null) {
                Iterator iter = files.iterator();
                while (iter.hasNext() && !reporter.isCancelled()) {
                    IFile file = (IFile)iter.next();
                    if (!AbstractNestedValidator.shouldValidate(file)) continue;
                    this.validate(file, null, null, reporter, nestedcontext);
                }
            }
        }
        this.teardownValidation(nestedcontext);
        if (reporter.isCancelled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected String getValidatorID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void setupValidation(NestedValidatorContext context) {
    }

    protected void teardownValidation(NestedValidatorContext context) {
    }

    public ISchedulingRule getSchedulingRule(IValidationContext arg0) {
        return null;
    }

    public void cleanup(IReporter arg0) {
    }

    public void validate(IValidationContext context, IReporter reporter) throws ValidationException {
        this.validateInJob(context, reporter);
    }

    private static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    private void validate(IFile file, InputStream inputstream, ValidationResult result, IReporter reporter, NestedValidatorContext context) {
        LocalizedMessage message = new LocalizedMessage(4, file.getFullPath().toString());
        reporter.displaySubtask((IValidator)this, (IMessage)message);
        String locationString = null;
        if (file.getLocation() != null) {
            locationString = file.getLocation().toString();
        }
        if (locationString == null && file.getLocationURI() != null) {
            locationString = file.getLocationURI().toString();
        }
        if (locationString == null) {
            locationString = file.getFullPath().toString();
        }
        String uri = this.createURIForFilePath(locationString);
        this.clearMarkers(file, (IValidator)this, reporter);
        ValidationReport valreport = null;
        valreport = result == null ? this.validate(uri, inputstream, context) : this.validate(uri, inputstream, context, result);
        this.createMarkers(file, valreport.getValidationMessages(), reporter);
        try {
            file.setSessionProperty(ValidationMessage.ERROR_MESSAGE_MAP_QUALIFIED_NAME, (Object)valreport.getNestedMessages());
        }
        catch (CoreException coreException) {
            System.out.println("Unable to set nested messages property.");
        }
    }

    public abstract ValidationReport validate(String var1, InputStream var2, NestedValidatorContext var3);

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context, ValidationResult result) {
        return this.validate(uri, inputstream, context);
    }

    public ValidationReport validateWithSetup(String uri, InputStream inputstream, NestedValidatorContext context) {
        this.setupValidation(context);
        return this.validate(uri, inputstream, context);
    }

    private void clearMarkers(IFile iFile, IValidator validator, IReporter reporter) {
        if (this.fileIsAccessible(iFile)) {
            reporter.removeAllMessages(validator, (Object)iFile);
        }
    }

    private boolean fileIsAccessible(IFile file) {
        return file != null && file.exists() && file.getProject().isAccessible();
    }

    private String createURIForFilePath(String filename) {
        if (!filename.startsWith(FILE_PROTOCOL_NO_SLASH)) {
            while (filename.startsWith("/")) {
                filename = filename.substring(1);
            }
            filename = FILE_PROTOCOL + filename;
        }
        return filename;
    }

    public void createMarkers(IFile iFile, ValidationMessage[] valmessages, IReporter reporter) {
        if (!this.fileIsAccessible(iFile)) {
            return;
        }
        int nummessages = valmessages.length;
        int i = 0;
        while (i < nummessages) {
            List nestederrors;
            Object obj;
            ValidationMessage validationMessage = valmessages[i];
            String uri = validationMessage.getUri();
            LocalizedMessage message = validationMessage.getSeverity() == 4 ? new LocalizedMessage(2, validationMessage.getMessage(), (IResource)iFile) : new LocalizedMessage(1, validationMessage.getMessage(), (IResource)iFile);
            message.setLineNo(validationMessage.getLineNumber());
            this.addInfoToMessage(validationMessage, (IMessage)message);
            Object[] objlist = validationMessage.getMessageArguments();
            if (objlist != null && objlist.length == 1 && (obj = objlist[0]) instanceof AnnotationMsg) {
                message.setAttribute(AnnotationMsg.PROBMLEM_ID, new Integer(((AnnotationMsg)obj).getProblemId()));
                message.setAttribute(AnnotationMsg.LENGTH, new Integer(((AnnotationMsg)obj).getLength()));
                Object obj1 = ((AnnotationMsg)obj).getAttributeValueText();
                if (obj1 instanceof String) {
                    message.setAttribute(AnnotationMsg.ATTRVALUETEXT, obj1);
                } else if (obj1 instanceof Object[]) {
                    Object[] objArray = (Object[])obj1;
                    message.setAttribute(AnnotationMsg.ATTRVALUENO, new Integer(objArray.length));
                    int j = 0;
                    while (j < objArray.length) {
                        Object obj2 = objArray[j];
                        String attrName = String.valueOf(AnnotationMsg.ATTRNO) + j;
                        message.setAttribute(attrName, obj2);
                        ++j;
                    }
                }
            }
            if ((nestederrors = validationMessage.getNestedMessages()) != null && !nestederrors.isEmpty()) {
                message.setGroupName(REFERENCED_FILE_ERROR_OPEN + uri + REFERENCED_FILE_ERROR_CLOSE);
            }
            reporter.addMessage((IValidator)this, (IMessage)message);
            ++i;
        }
    }

    protected void addInfoToMessage(ValidationMessage validationmessage, IMessage message) {
    }

    protected NestedValidatorContext getNestedContext(ValidationState state, boolean create) {
        NestedValidatorContext context = null;
        if (create) {
            context = new NestedValidatorContext();
        }
        return context;
    }

    class LocalizedMessage
    extends Message {
        private String _message;

        public LocalizedMessage(int severity, String messageText) {
            this(severity, messageText, null);
        }

        public LocalizedMessage(int severity, String messageText, IResource targetObject) {
            this(severity, messageText, (Object)targetObject);
        }

        public LocalizedMessage(int severity, String messageText, Object targetObject) {
            super(null, severity, null);
            this._message = null;
            this.setLocalizedMessage(messageText);
            this.setTargetObject(targetObject);
        }

        public void setLocalizedMessage(String message) {
            this._message = message;
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedMessage();
        }
    }
}

