/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.scripting.core.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.RecognitionException;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.incubator.internal.filters.core.server.FilterValidation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TmfFilterAppliedSignal;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TraceCompassFilter;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class FiltersScriptingModule {
    @WrapToScript
    public void applyGlobalFilter(String regex) {
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace == null) {
            return;
        }
        try {
            List validate = FilterValidation.validate((String)regex);
            if (validate.isEmpty()) {
                trace.broadcast((TmfSignal)new TmfFilterAppliedSignal((Object)trace, trace, TraceCompassFilter.fromRegex(Collections.singleton(regex), (ITmfTrace)trace)));
            }
        }
        catch (IOException | RecognitionException throwable) {}
    }

    @WrapToScript
    public void filterByThreadName(String name) {
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace == null) {
            return;
        }
        List<Integer> tids = FiltersScriptingModule.findMatchName(name, trace);
        if (tids.size() == 0) {
            return;
        }
        String prefix = String.valueOf(OsStrings.tid()) + "==";
        String separator = " || " + prefix;
        StringJoiner regexJoiner = new StringJoiner(separator, prefix, "");
        for (Integer tid : tids) {
            regexJoiner.add(tid.toString());
        }
        String regexExpression = regexJoiner.toString();
        if (regexExpression != null) {
            this.applyGlobalFilter(regexExpression);
        }
    }

    private static List<Integer> findMatchName(String name, ITmfTrace trace) {
        Map<Integer, String> executableNames = FiltersScriptingModule.getExecutableNames(trace);
        ArrayList<Integer> tids = new ArrayList<Integer>();
        Pattern checkRegex = Pattern.compile(name);
        for (Map.Entry<Integer, String> entry : executableNames.entrySet()) {
            Matcher regexMatcher = checkRegex.matcher(entry.getValue());
            if (!regexMatcher.find()) continue;
            tids.add(entry.getKey());
        }
        return tids;
    }

    private static Map<Integer, String> getExecutableNames(ITmfTrace trace) {
        HashMap<Integer, String> executableNames = new HashMap<Integer, String>();
        KernelAnalysisModule kernelAnlysis = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (kernelAnlysis == null) {
            return Collections.emptyMap();
        }
        Collection threadIds = KernelThreadInformationProvider.getThreadIds((KernelAnalysisModule)kernelAnlysis);
        if (threadIds.isEmpty()) {
            return Collections.emptyMap();
        }
        for (Integer tid : threadIds) {
            String execName = KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)kernelAnlysis, (Integer)tid);
            if (execName == null) continue;
            executableNames.put(tid, execName);
        }
        return executableNames;
    }

    @WrapToScript
    public void clearGlobalFilters() {
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace == null) {
            return;
        }
        trace.broadcast((TmfSignal)new TmfFilterAppliedSignal((Object)trace, trace, TraceCompassFilter.fromRegex(Collections.emptyList(), (ITmfTrace)trace)));
    }
}

