/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.ui.views.flamechart;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.CallStackEntryModel;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.views.flamechart.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class CallStackPresentationProvider
extends TimeGraphPresentationProvider {
    public static final int NUM_COLORS = 360;
    private static final StateItem[] STATE_TABLE = new StateItem[361];
    private IPaletteProvider fPalette = new RotatingPaletteProvider.Builder().setNbColors(360).build();

    static {
        CallStackPresentationProvider.STATE_TABLE[0] = new StateItem(State.MULTIPLE.rgb, State.MULTIPLE.toString());
    }

    public @Nullable String getStateTypeName(@Nullable ITimeGraphEntry entry) {
        ITmfTreeDataModel model;
        if (entry instanceof TimeGraphEntry && (model = ((TimeGraphEntry)entry).getEntryModel()) instanceof CallStackEntryModel) {
            int type = ((CallStackEntryModel)model).getStackLevel();
            if (type >= 0) {
                return Messages.CallStackPresentationProvider_Thread;
            }
            if (type == -1) {
                return Messages.CallStackPresentationProvider_Process;
            }
        }
        return null;
    }

    public StateItem[] getStateTable() {
        if (STATE_TABLE[1] == null) {
            int i = 1;
            for (RGBAColor color : this.fPalette.get()) {
                CallStackPresentationProvider.STATE_TABLE[i] = new StateItem(RGBAUtil.fromRGBAColor((RGBAColor)color).rgb, color.toString());
                ++i;
            }
        }
        return STATE_TABLE;
    }

    public int getStateTableIndex(@Nullable ITimeEvent event) {
        if (event instanceof NamedTimeEvent) {
            NamedTimeEvent callStackEvent = (NamedTimeEvent)event;
            return Math.floorMod(callStackEvent.getValue(), this.fPalette.get().size()) + 1;
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return State.MULTIPLE.ordinal();
    }

    public String getEventName(@Nullable ITimeEvent event) {
        if (event instanceof NamedTimeEvent) {
            return ((NamedTimeEvent)event).getLabel();
        }
        return State.MULTIPLE.toString();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNullByDefault(value={})
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        LinkedHashMap<String, String> retMap = super.getEventHoverToolTipInfo(event, hoverTime);
        if (retMap == null) {
            retMap = new LinkedHashMap<String, String>(1);
        }
        if (!(event instanceof TimeEvent && ((TimeEvent)event).hasValue() && event.getEntry() instanceof TimeGraphEntry)) {
            return retMap;
        }
        TimeGraphEntry entry = (TimeGraphEntry)event.getEntry();
        ITimeGraphDataProvider dataProvider = BaseDataProviderTimeGraphView.getProvider((TimeGraphEntry)entry);
        @NonNull @NonNull @NonNull TmfModelResponse response = dataProvider.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(hoverTime, hoverTime, 1, Collections.singletonList(entry.getEntryModel().getId()))), null);
        @NonNull @NonNull Map tooltipModel = (Map)response.getModel();
        if (tooltipModel != null) {
            retMap.putAll(tooltipModel);
        }
        return retMap;
    }

    private static enum State {
        MULTIPLE(new RGB(100, 100, 100)),
        EXEC(new RGB(0, 200, 0));

        private final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

