/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static final String RUN_AWT_INVOKE_LATER_KEY = "org.eclipse.swt.internal.runAWTInvokeLater";
    static final String JDK17_FRAME = "sun.lwawt.macosx.CViewEmbeddedFrame";
    static boolean loaded;
    static boolean swingInitialized;

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }

    static final native long getAWTHandle(Canvas var0);

    static final native Object initFrame(long var0, String var2);

    static final native void validateWithBounds(Frame var0, int var1, int var2, int var3, int var4);

    static final native void synthesizeWindowActivation(Frame var0, boolean var1);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        Toolkit.getDefaultToolkit();
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {}
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        try {
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", new Class[0]);
            if (method != null) {
                method.invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable throwable) {}
    }

    public static Frame getFrame(Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)parent.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(final Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        final long handle = parent.view.id;
        final String className = embeddedFrameClass != null ? embeddedFrameClass : JDK17_FRAME;
        try {
            if (embeddedFrameClass != null) {
                Class.forName(className);
            }
            SWT_AWT.loadLibrary();
        }
        catch (ClassNotFoundException cne) {
            SWT.error(20, cne);
        }
        catch (Throwable e2) {
            SWT.error(1, e2, " [Error while starting AWT]");
        }
        SWT_AWT.initializeSwing();
        final Frame[] result = new Frame[1];
        final Throwable[] exception = new Throwable[1];
        Runnable runnable = new Runnable(){
            boolean run;

            @Override
            public void run() {
                if (this.run) {
                    return;
                }
                this.run = true;
                Object obj = SWT_AWT.initFrame(handle, className);
                if (obj == null || !(obj instanceof Frame)) {
                    exception[0] = new Throwable("[Error while creating AWT embedded frame]");
                    SWT.error(1, exception[0]);
                    return;
                }
                result[0] = (Frame)obj;
                result[0].addNotify();
            }
        };
        if (EventQueue.isDispatchThread() || parent.getDisplay().getSyncThread() != null) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
            Display display = parent.getDisplay();
            while (result[0] == null && exception[0] == null) {
                display.setData(RUN_AWT_INVOKE_LATER_KEY, true);
                Boolean invoked = (Boolean)display.getData(RUN_AWT_INVOKE_LATER_KEY);
                if (invoked == null || invoked.booleanValue()) continue;
                runnable.run();
            }
        }
        if (exception[0] != null) {
            SWT.error(20, exception[0]);
        }
        final Frame frame = result[0];
        parent.setData(EMBEDDED_FRAME_KEY, frame);
        final Listener shellListener = e -> {
            switch (e.type) {
                case 20: {
                    EventQueue.invokeLater(() -> frame.dispatchEvent(new WindowEvent(frame, 204)));
                    break;
                }
                case 19: {
                    EventQueue.invokeLater(() -> frame.dispatchEvent(new WindowEvent(frame, 203)));
                }
            }
        };
        Shell shell = parent.getShell();
        shell.addListener(20, shellListener);
        shell.addListener(19, shellListener);
        final Display display = parent.getDisplay();
        display.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                while (frame.isDisplayable() && !display.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                if (!display.isDisposed()) {
                    display.removeListener(12, this);
                }
            }
        });
        Listener listener = new Listener(){

            @Override
            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        Shell shell = parent.getShell();
                        shell.removeListener(20, shellListener);
                        shell.removeListener(19, shellListener);
                        shell.removeListener(26, this);
                        shell.removeListener(27, this);
                        parent.setVisible(false);
                        EventQueue.invokeLater(() -> {
                            try {
                                frame.dispose();
                            }
                            catch (Throwable throwable) {}
                        });
                        break;
                    }
                    case 26: {
                        if (!parent.isFocusControl()) {
                            return;
                        }
                    }
                    case 15: {
                        EventQueue.invokeLater(() -> {
                            if (frame.isActive()) {
                                return;
                            }
                            try {
                                SWT_AWT.synthesizeWindowActivation(frame, Boolean.TRUE);
                            }
                            catch (Throwable e1) {
                                e1.printStackTrace();
                            }
                        });
                        break;
                    }
                    case 16: 
                    case 27: {
                        EventQueue.invokeLater(() -> {
                            if (!frame.isActive()) {
                                return;
                            }
                            try {
                                SWT_AWT.synthesizeWindowActivation(frame, Boolean.FALSE);
                            }
                            catch (Throwable e1) {
                                e1.printStackTrace();
                            }
                        });
                    }
                }
            }
        };
        parent.addListener(15, listener);
        parent.addListener(16, listener);
        shell.addListener(26, listener);
        shell.addListener(27, listener);
        parent.addListener(12, listener);
        display.asyncExec(() -> {
            if (parent.isDisposed()) {
                return;
            }
            Rectangle clientArea = parent.getClientArea();
            try {
                SWT_AWT.validateWithBounds(frame, clientArea.x, clientArea.y, clientArea.width, clientArea.height);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        return frame;
    }

    public static Shell new_Shell(final Display display, final Canvas parent) {
        if (display == null) {
            SWT.error(4);
        }
        if (parent == null) {
            SWT.error(4);
        }
        long handle = 0L;
        try {
            SWT_AWT.loadLibrary();
            handle = SWT_AWT.getAWTHandle(parent);
        }
        catch (Throwable e) {
            SWT.error(20, e);
        }
        if (handle == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.cocoa_new(display, handle);
        ComponentAdapter listener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                display.asyncExec(() -> {
                    if (shell.isDisposed()) {
                        return;
                    }
                    Dimension dim = parent.getSize();
                    shell.setSize(dim.width, dim.height);
                });
            }
        };
        parent.addComponentListener(listener);
        shell.addListener(12, event -> parent.removeComponentListener(listener));
        shell.setVisible(true);
        return shell;
    }
}

