/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.variant;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.variant.VariantBodyParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class VariantParser
extends AbstractScopedCommonTreeParser {
    private static final String OPTIONS = "options";
    private static final String SELECTOR_FIELD_LOCATION = "selector-field-location";
    public static final VariantParser INSTANCE = new VariantParser();

    private VariantParser() {
    }

    @Override
    public VariantDeclaration parse(ICTFMetadataNode variant, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        VariantDeclaration variantDeclaration = null;
        boolean hasName = false;
        String variantName = null;
        boolean hasBody = false;
        ICTFMetadataNode variantBody = null;
        boolean hasTag = false;
        String variantTag = null;
        if (variant instanceof JsonStructureFieldMemberMetadataNode) {
            JsonObject fieldClass = ((JsonStructureFieldMemberMetadataNode)variant).getFieldClass().getAsJsonObject();
            if (fieldClass.has(SELECTOR_FIELD_LOCATION)) {
                JsonArray location = fieldClass.get(SELECTOR_FIELD_LOCATION).getAsJsonObject().get("path").getAsJsonArray();
                variantTag = location.get(location.size() - 1).getAsString();
                hasTag = true;
            }
            if (fieldClass.has(OPTIONS)) {
                JsonArray options = fieldClass.get(OPTIONS).getAsJsonArray();
                ArrayList<JsonStructureFieldMemberMetadataNode> memberClasses = new ArrayList<JsonStructureFieldMemberMetadataNode>();
                for (JsonElement opt : options) {
                    JsonStructureFieldMemberMetadataNode memberClass = Objects.requireNonNull((JsonStructureFieldMemberMetadataNode)new Gson().fromJson(opt, JsonStructureFieldMemberMetadataNode.class));
                    memberClasses.add(memberClass);
                }
                JsonStructureFieldMetadataNode body = new JsonStructureFieldMetadataNode(variant, "structure", null);
                body.setMemberClasses(memberClasses);
                try {
                    body.initialize();
                }
                catch (CTFException e) {
                    throw new ParseException("initialization issue ", e);
                }
                variantBody = variant;
                hasBody = true;
            }
        } else {
            List<ICTFMetadataNode> children = variant.getChildren();
            for (ICTFMetadataNode child : children) {
                String type = child.getType();
                if (CTFParser.tokenNames[125].equals(type)) {
                    hasName = true;
                    ICTFMetadataNode variantNameIdentifier = child.getChild(0);
                    variantName = variantNameIdentifier.getText();
                    continue;
                }
                if (CTFParser.tokenNames[126].equals(type)) {
                    hasTag = true;
                    ICTFMetadataNode variantTagIdentifier = child.getChild(0);
                    variantTag = variantTagIdentifier.getText();
                    continue;
                }
                if (CTFParser.tokenNames[124].equals(type)) {
                    hasBody = true;
                    variantBody = child;
                    continue;
                }
                throw TsdlUtils.childTypeError(child);
            }
        }
        if (hasBody) {
            if (hasName && scope.lookupVariant(variantName) != null) {
                throw new ParseException("variant " + variantName + " already defined.");
            }
            variantDeclaration = new VariantDeclaration();
            CTFTrace trace = ((Param)param).fTrace;
            VariantBodyParser.INSTANCE.parse(variantBody, new VariantBodyParser.Param(variantDeclaration, trace, variantName, scope));
            if (hasName) {
                scope.registerVariant(variantName, variantDeclaration);
            }
        } else if (hasName) {
            variantDeclaration = scope.lookupVariantRecursive(variantName);
            if (variantDeclaration == null) {
                throw new ParseException("variant " + variantName + " is not defined");
            }
        } else {
            throw new ParseException("variant with no name and no body");
        }
        if (hasTag) {
            variantDeclaration.setTag(variantTag);
            IDeclaration decl = scope.lookupIdentifierRecursive(variantTag);
            if (decl == null) {
                throw new ParseException("Variant tag not found: " + variantTag);
            }
            if (decl instanceof EnumDeclaration) {
                EnumDeclaration tagDecl = (EnumDeclaration)decl;
                if (!VariantParser.intersects(tagDecl.getLabels(), variantDeclaration.getFields().keySet())) {
                    throw new ParseException("Variant contains no values of the tag, impossible to use: " + variantName);
                }
            } else if (!(decl instanceof IntegerDeclaration)) {
                throw new ParseException("Variant tag must be an enum or an int: " + variantTag);
            }
        }
        return variantDeclaration;
    }

    private static boolean intersects(Set<String> set, Set<String> fasterSet) {
        for (String setString : set) {
            if (!fasterSet.contains(setString)) continue;
            return true;
        }
        return false;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope scope) {
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

