/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.ui.actions;

import com.google.common.collect.Multimap;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModel;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModelType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2FlowTargetInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2FlowTargetType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2PubInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.signals.Ros2FlowItemSelectedSignal;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.messages.Ros2MessagesView;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class Ros2FollowMessageAction
extends Action {
    private static final @NonNull String IMG_UI = "icons/elcl16/follow_message.gif";
    private static final @NonNull String ACTION_TEXT = "Follow";
    private static final @NonNull String ACTION_TOOLTIP_TEXT = "Follow this element";
    private final TmfView fView;
    private final TimeGraphViewer fTimeGraphViewer;

    public Ros2FollowMessageAction(TmfView source, TimeGraphViewer timeGraphViewer) {
        this.fTimeGraphViewer = timeGraphViewer;
        this.fView = source;
        this.setText(ACTION_TEXT);
        this.setToolTipText(ACTION_TOOLTIP_TEXT);
        this.setImageDescriptor(Objects.requireNonNull(Activator.getDefault()).getImageDescripterFromPath(IMG_UI));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void run() {
        long selectionBegin = this.fTimeGraphViewer.getSelectionBegin();
        ITimeGraphEntry selection = this.fTimeGraphViewer.getSelection();
        if (selection == null) {
            return;
        }
        @Nullable ITimeEvent refEvent = Ros2MessagesView.getReferenceEvent(selection, selectionBegin);
        if (refEvent != null) {
            Ros2FlowTargetInfo info;
            ITmfTreeDataModel model = ((TimeGraphEntry)refEvent.getEntry()).getEntryModel();
            if (!(model instanceof Ros2ObjectTimeGraphEntryModel)) {
                return;
            }
            Ros2ObjectTimeGraphEntryModel messagesModel = (Ros2ObjectTimeGraphEntryModel)model;
            @NonNull @NonNull Multimap metadata = refEvent.getMetadata();
            Ros2ObjectTimeGraphEntryModelType type = messagesModel.getType();
            long startTime = refEvent.getTime();
            long endTime = startTime + refEvent.getDuration() - 1L;
            if (Ros2ObjectTimeGraphEntryModelType.PUBLISHER == type) {
                Ros2PubInstance pub = (Ros2PubInstance)metadata.get((Object)"data").iterator().next();
                info = new Ros2FlowTargetInfo(startTime, endTime, Ros2FlowTargetType.PUBLISHER, (Object)pub);
            } else if (Ros2ObjectTimeGraphEntryModelType.SUBSCRIPTION == type) {
                Object takeOrCallback = metadata.get((Object)"data").iterator().next();
                info = new Ros2FlowTargetInfo(startTime, endTime, Ros2FlowTargetType.SUBSCRIPTION, takeOrCallback);
            } else if (Ros2ObjectTimeGraphEntryModelType.TIMER == type) {
                Ros2CallbackInstance callback = (Ros2CallbackInstance)metadata.get((Object)"data").iterator().next();
                info = new Ros2FlowTargetInfo(startTime, endTime, Ros2FlowTargetType.TIMER, (Object)callback);
            } else {
                return;
            }
            this.fView.broadcast((TmfSignal)new Ros2FlowItemSelectedSignal((Object)this.fView, info));
            super.run();
        }
    }
}

