/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.properties;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.scripts.Activator;
import org.eclipse.ease.ui.scripts.Messages;
import org.eclipse.ease.ui.scripts.expressions.IExpressionDefinition;
import org.eclipse.ease.ui.scripts.expressions.ui.ExpressionDialog;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.tools.LocationImageDescriptor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.dialogs.ShowViewDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ScriptUIIntegrationSection
extends AbstractPropertySection {
    private Text fTxtName;
    private Text fTxtImage;
    private Text fTxtDescription;
    private Text fTxtToolbar;
    private Text fTxtMenu;
    private Text fTxtPopup;
    private Label fLblImagePic;
    private Section fSctnLookFeel;
    private Section fSctnMenusToolbars;
    private DataBindingContext fContext = null;

    public void createControls(final Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(1, false));
        this.fSctnLookFeel = this.getWidgetFactory().createSection(parent, 266);
        this.fSctnLookFeel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.getWidgetFactory().paintBordersFor((Composite)this.fSctnLookFeel);
        this.fSctnLookFeel.setText(Messages.ScriptUIIntegrationSection_lockAndFeel);
        this.fSctnLookFeel.setExpanded(true);
        Composite composite = this.getWidgetFactory().createComposite((Composite)this.fSctnLookFeel, 0);
        this.getWidgetFactory().paintBordersFor(composite);
        this.fSctnLookFeel.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(4, false));
        Label lblName = this.getWidgetFactory().createLabel(composite, Messages.ScriptUIIntegrationSection_name, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.fTxtName = this.getWidgetFactory().createText(composite, "", 0);
        this.fTxtName.setToolTipText(Messages.ScriptUIIntegrationSection_enterDisplayName);
        this.fTxtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Composite composite_2 = this.getWidgetFactory().createComposite(composite, 0);
        composite_2.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        this.getWidgetFactory().paintBordersFor(composite_2);
        GridLayout gl_composite_2 = new GridLayout(2, false);
        gl_composite_2.horizontalSpacing = 0;
        gl_composite_2.verticalSpacing = 0;
        gl_composite_2.marginWidth = 0;
        composite_2.setLayout((Layout)gl_composite_2);
        this.fLblImagePic = this.getWidgetFactory().createLabel(composite_2, "", 0);
        GridData gd_lblImagePic = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_lblImagePic.widthHint = 20;
        gd_lblImagePic.heightHint = 20;
        this.fLblImagePic.setLayoutData((Object)gd_lblImagePic);
        Label lblImage = this.getWidgetFactory().createLabel(composite_2, Messages.ScriptUIIntegrationSection_image, 0);
        lblImage.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.fTxtImage = this.getWidgetFactory().createText(composite, "", 0);
        this.fTxtImage.setToolTipText(Messages.ScriptUIIntegrationSection_imageUri);
        this.fTxtImage.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fTxtImage.addModifyListener(e -> this.updateImagePreview());
        Button btnBrowseWorkspace = this.getWidgetFactory().createButton(composite, "", 0);
        btnBrowseWorkspace.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT"));
        btnBrowseWorkspace.setToolTipText(Messages.ScriptUIIntegrationSection_browseWorkspace);
        btnBrowseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object result;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider(){

                    public Object[] getChildren(Object element) {
                        ArrayList<Object> result = new ArrayList<Object>();
                        Object[] objectArray = super.getChildren(element);
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object candidate = objectArray[n2];
                            if (candidate instanceof IFile) {
                                String extension = ((IFile)candidate).getFileExtension();
                                if ("png".equalsIgnoreCase(extension) || "gif".equalsIgnoreCase(extension) || "ico".equalsIgnoreCase(extension)) {
                                    result.add(candidate);
                                }
                            } else if (candidate instanceof IContainer && this.containsImages((IContainer)candidate)) {
                                result.add(candidate);
                            }
                            ++n2;
                        }
                        return result.toArray(new Object[result.size()]);
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    private boolean containsImages(IContainer container) {
                        try {
                            IResource member;
                            IResource[] iResourceArray = container.members();
                            int n = iResourceArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                member = iResourceArray[n2];
                                String extension = member.getFileExtension();
                                if ("png".equalsIgnoreCase(extension)) return true;
                                if ("gif".equalsIgnoreCase(extension)) return true;
                                if ("ico".equalsIgnoreCase(extension)) {
                                    return true;
                                }
                                ++n2;
                            }
                            iResourceArray = container.members();
                            n = iResourceArray.length;
                            n2 = 0;
                            while (n2 < n) {
                                member = iResourceArray[n2];
                                if (member instanceof IContainer && this.containsImages((IContainer)member)) {
                                    return true;
                                }
                                ++n2;
                            }
                            return false;
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        return false;
                    }
                });
                dialog.setTitle(Messages.ScriptUIIntegrationSection_selectImage);
                dialog.setMessage(Messages.ScriptUIIntegrationSection_selectImageForScript);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof IFile) {
                    ScriptUIIntegrationSection.this.fTxtImage.setText("workspace:/" + ((IFile)result).getFullPath().toPortableString());
                }
            }
        });
        Button btnBrowseFileSystem = this.getWidgetFactory().createButton(composite, "", 0);
        btnBrowseFileSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(parent.getShell(), 4096);
                fileDialog.setFilterNames(new String[]{Messages.ScriptUIIntegrationSection_images, Messages.ScriptUIIntegrationSection_allFiles});
                fileDialog.setFilterExtensions(new String[]{"*.png;*.gif;*.ico", "*.*"});
                String location = fileDialog.open();
                if (location != null) {
                    ScriptUIIntegrationSection.this.fTxtImage.setText(new File(location).toURI().toString());
                }
            }
        });
        btnBrowseFileSystem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        btnBrowseFileSystem.setToolTipText(Messages.ScriptUIIntegrationSection_browseLocal);
        Label label_2 = this.getWidgetFactory().createLabel(composite, Messages.ScriptUIIntegrationSection_description, 0);
        label_2.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.fTxtDescription = this.getWidgetFactory().createText(composite, "", 578);
        this.fTxtDescription.setToolTipText(Messages.ScriptUIIntegrationSection_descriptionTooltip);
        GridData gd_text_2 = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_text_2.heightHint = 62;
        this.fTxtDescription.setLayoutData((Object)gd_text_2);
        this.fSctnMenusToolbars = this.getWidgetFactory().createSection(parent, 266);
        this.fSctnMenusToolbars.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.getWidgetFactory().paintBordersFor((Composite)this.fSctnMenusToolbars);
        this.fSctnMenusToolbars.setText(Messages.ScriptUIIntegrationSection_menuAndToolbars);
        this.fSctnMenusToolbars.setExpanded(true);
        Composite composite_1 = this.getWidgetFactory().createComposite((Composite)this.fSctnMenusToolbars, 0);
        this.getWidgetFactory().paintBordersFor(composite_1);
        this.fSctnMenusToolbars.setClient((Control)composite_1);
        composite_1.setLayout((Layout)new GridLayout(4, false));
        Label lblToolbar = this.getWidgetFactory().createLabel(composite_1, Messages.ScriptUIIntegrationSection_toolbar, 0);
        lblToolbar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.fTxtToolbar = this.getWidgetFactory().createText(composite_1, "", 0);
        this.fTxtToolbar.setToolTipText(Messages.ScriptUIIntegrationSection_toolbarToolTip);
        this.fTxtToolbar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.addBrowseButton(composite_1, this.fTxtToolbar);
        this.addBuildExpressionButton(composite_1, this.fTxtToolbar);
        Label lblMenu = this.getWidgetFactory().createLabel(composite_1, Messages.ScriptUIIntegrationSection_menu, 0);
        lblMenu.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.fTxtMenu = this.getWidgetFactory().createText(composite_1, "", 0);
        this.fTxtMenu.setToolTipText(Messages.ScriptUIIntegrationSection_menuToolTip);
        this.fTxtMenu.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.addBrowseButton(composite_1, this.fTxtMenu);
        this.addBuildExpressionButton(composite_1, this.fTxtMenu);
        Label lblPopup = this.getWidgetFactory().createLabel(composite_1, Messages.ScriptUIIntegrationSection_popup, 0);
        lblPopup.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.fTxtPopup = this.getWidgetFactory().createText(composite_1, "", 0);
        this.fTxtPopup.setToolTipText(Messages.ScriptUIIntegrationSection_popupToolTip);
        this.fTxtPopup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.addBrowseButton(composite_1, this.fTxtPopup);
        this.addBuildExpressionButton(composite_1, this.fTxtPopup);
    }

    private void updateImagePreview() {
        Image newImage = null;
        if (!this.fTxtImage.getText().isEmpty()) {
            ImageDescriptor descriptor;
            String imageLocation = ResourceTools.toAbsoluteLocation((Object)this.fTxtImage.getText(), (Object)this.getScript().getLocation());
            if (imageLocation == null) {
                imageLocation = this.fTxtImage.getText().trim();
            }
            if ((descriptor = LocationImageDescriptor.createFromLocation((String)imageLocation)) != null) {
                newImage = descriptor.createImage();
            }
        }
        Image oldImage = this.fLblImagePic.getImage();
        this.fLblImagePic.setImage(newImage);
        if (oldImage != null) {
            oldImage.dispose();
        }
    }

    public void refresh() {
        if (this.fContext != null) {
            this.fContext.dispose();
        }
        this.fContext = new DataBindingContext();
        IScript script = this.getScript();
        String[] keywords = new String[]{"name", "image", "description", "toolbar", "menu", "popup"};
        Text[] widgets = new Text[]{this.fTxtName, this.fTxtImage, this.fTxtDescription, this.fTxtToolbar, this.fTxtMenu, this.fTxtPopup};
        int index = 0;
        while (index < Math.min(keywords.length, widgets.length)) {
            String value = script.getKeywords().get(keywords[index]);
            widgets[index].setText(value != null ? value : "");
            ISWTObservableValue sourceValue = WidgetProperties.text((int)24).observeDelayed(300, (Widget)widgets[index]);
            KeywordObservableValue targetValue = new KeywordObservableValue(script, keywords[index]);
            this.fContext.bindValue((IObservableValue)targetValue, (IObservableValue)sourceValue, null, null);
            ++index;
        }
        this.updateImagePreview();
        this.fSctnLookFeel.layout();
        this.fSctnMenusToolbars.layout();
    }

    private void addBuildExpressionButton(Composite parent, final Text text) {
        Button btnBuildExpression = this.getWidgetFactory().createButton(parent, "", 0);
        ImageDescriptor imageDescriptor = Activator.getImageDescriptor("/icons/eobj16/expression.png");
        btnBuildExpression.setImage(imageDescriptor.createImage());
        btnBuildExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog dialog = new ExpressionDialog(null, Messages.ScriptUIIntegrationSection_expressionDialogTitle, "enabledWhen");
                if (dialog.open() == 0) {
                    IExpressionDefinition expression = dialog.getExpression();
                    text.setText(String.valueOf(text.getText()) + " enabledWhen(" + expression.serialize() + ")");
                }
            }
        });
    }

    private void addBrowseButton(final Composite parent, final Text text) {
        Button btnBrowse = this.getWidgetFactory().createButton(parent, "", 0);
        ImageDescriptor imageDescriptor = Activator.getImageDescriptor("/icons/eobj16/select_view.png");
        btnBrowse.setImage(imageDescriptor.createImage());
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = parent.getShell();
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IEclipseContext ctx = (IEclipseContext)workbenchWindow.getService(IEclipseContext.class);
                EModelService modelService = (EModelService)workbenchWindow.getService(EModelService.class);
                MWindow window = (MWindow)workbenchWindow.getService(MWindow.class);
                EPartService partService = (EPartService)workbenchWindow.getService(EPartService.class);
                IWorkbench workbench = (IWorkbench)ctx.get(IWorkbench.class);
                MApplication app = workbench.getApplication();
                ShowViewDialog dialog = new ShowViewDialog(shell, app, window, modelService, partService, ctx);
                if (dialog.open() == 0) {
                    MPartDescriptor[] descriptors;
                    MPartDescriptor[] mPartDescriptorArray = descriptors = dialog.getSelection();
                    int n = descriptors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MPartDescriptor descriptor = mPartDescriptorArray[n2];
                        text.setText(descriptor.getElementId());
                        ++n2;
                    }
                }
            }
        });
    }

    protected IScript getScript() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object candidate = ((IStructuredSelection)selection).getFirstElement();
            return (IScript)(candidate instanceof IScript ? candidate : null);
        }
        return null;
    }

    private static final class KeywordObservableValue
    extends AbstractObservableValue<String> {
        private final IScript fScript;
        private final String fKeyword;

        private KeywordObservableValue(IScript script, String keyword) {
            this.fScript = script;
            this.fKeyword = keyword;
        }

        public Object getValueType() {
            return String.class;
        }

        protected String doGetValue() {
            return (String)this.fScript.getUserKeywords().get((Object)this.fKeyword);
        }

        protected void doSetValue(String value) {
            this.fScript.setUserKeyword(this.fKeyword, value.trim().isEmpty() ? null : value.trim());
        }
    }
}

