/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.dialogs;

import org.eclipse.ease.ui.scripts.Messages;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.scripts.repository.impl.RepositoryService;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddKeywordDialog
extends TitleAreaDialog {
    private Text fTxtValue;
    private ComboViewer fComboViewer;
    private final IScript fScript;
    private String fSelectedKeyword;
    private String fSelectedValue;

    public AddKeywordDialog(Shell parentShell, IScript script) {
        super(parentShell);
        this.fScript = script;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.AddKeywordDialog_createNew);
        this.setMessage(Messages.AddKeywordDialog_text, 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(area, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Label lblKeyword = new Label(composite, 0);
        lblKeyword.setSize(47, 13);
        lblKeyword.setText(Messages.AddKeywordDialog_keyword);
        Validator validator = new Validator();
        this.fComboViewer = new ComboViewer(composite, 0);
        Combo combo = this.fComboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        combo.setSize(380, 20);
        this.fComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fComboViewer.setInput(RepositoryService.getSupportedKeywords());
        this.fComboViewer.setComparator(new ViewerComparator());
        combo.addModifyListener((ModifyListener)validator);
        Label lblValue = new Label(composite, 0);
        lblValue.setSize(30, 13);
        lblValue.setText(Messages.AddKeywordDialog_value);
        this.fTxtValue = new Text(composite, 2048);
        this.fTxtValue.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fTxtValue.setSize(380, 19);
        this.fTxtValue.addModifyListener((ModifyListener)validator);
        return area;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.fSelectedKeyword = this.fComboViewer.getCombo().getText();
        this.fSelectedValue = this.fTxtValue.getText();
        super.okPressed();
    }

    public String getKeyword() {
        return this.fSelectedKeyword;
    }

    public String getValue() {
        return this.fSelectedValue;
    }

    private class Validator
    implements ModifyListener {
        private Validator() {
        }

        public void modifyText(ModifyEvent e) {
            AddKeywordDialog.this.getButton(0).setEnabled(false);
            if (AddKeywordDialog.this.fComboViewer.getCombo().getText().trim().isEmpty()) {
                AddKeywordDialog.this.setMessage(Messages.AddKeywordDialog_emptyKey, 3);
            } else if (AddKeywordDialog.this.fTxtValue.getText().trim().isEmpty()) {
                AddKeywordDialog.this.setMessage(Messages.AddKeywordDialog_emptyValue, 3);
            } else if (AddKeywordDialog.this.fScript != null && AddKeywordDialog.this.fScript.getKeywords().containsKey(AddKeywordDialog.this.fComboViewer.getCombo().getText().trim())) {
                AddKeywordDialog.this.getButton(0).setEnabled(true);
                AddKeywordDialog.this.setMessage(Messages.AddKeywordDialog_keyAlreadyExists, 2);
            } else {
                AddKeywordDialog.this.getButton(0).setEnabled(true);
                AddKeywordDialog.this.setMessage(Messages.AddKeywordDialog_text, 1);
            }
        }
    }
}

