/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.completion;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completion.provider.AbstractCompletionProvider;

public class LaunchModuleCompletionProvider
extends AbstractCompletionProvider {
    public boolean isActive(ICompletionContext context) {
        if (this.isStringParameter(context) && context.getLoadedModules().contains(LaunchModuleCompletionProvider.getModuleDefinition((String)"/System/Launch"))) {
            return this.isLaunchConfigurationParameter(context) || this.isLaunchTypeParameter(context);
        }
        return false;
    }

    private boolean isLaunchConfigurationParameter(ICompletionContext context) {
        return this.isMethodParameter(context, "launch", 0) || this.isMethodParameter(context, "launchUI", 0) || this.isMethodParameter(context, "getLaunchConfiguration", 0);
    }

    private boolean isLaunchTypeParameter(ICompletionContext context) {
        return this.isMethodParameter(context, "launch", 1) || this.isMethodParameter(context, "launchUI", 1);
    }

    protected void prepareProposals(ICompletionContext context) {
        if (this.isLaunchConfigurationParameter(this.getContext())) {
            try {
                ILaunchConfiguration[] configurations;
                ILaunchConfiguration[] iLaunchConfigurationArray = configurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                int n = configurations.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                    String name = configuration.getName();
                    ILaunchConfigurationType type = configuration.getType();
                    String typeName = type.getName();
                    String display = String.valueOf(name) + " - " + typeName;
                    this.addProposal(display, name, (IImageResolver)new AbstractCompletionProvider.DescriptorImageResolver(DebugUITools.getDefaultImageDescriptor((Object)configuration)), 0, null);
                    ++n2;
                }
            }
            catch (CoreException e) {
                Logger.warning((String)"org.eclipse.ease.modules.platform", (String)"Code Completion: could not read launch configurations", (Throwable)e);
            }
        } else if (this.isLaunchTypeParameter(this.getContext())) {
            ArrayList proposals = new ArrayList();
            ILaunchGroup[] launchGroups = DebugUITools.getLaunchGroups();
            HashMap<String, ILaunchGroup> modes = new HashMap<String, ILaunchGroup>();
            ILaunchGroup[] type = launchGroups;
            int name = launchGroups.length;
            int n = 0;
            while (n < name) {
                ILaunchGroup launchGroup = type[n];
                modes.put(launchGroup.getMode(), launchGroup);
                ++n;
            }
            for (ILaunchGroup launchGroup : modes.values()) {
                String display = launchGroup.getLabel().replace("&", "");
                String name2 = launchGroup.getMode();
                this.addProposal(display, name2, (IImageResolver)new AbstractCompletionProvider.DescriptorImageResolver(launchGroup.getImageDescriptor()), 0, null);
            }
        }
    }
}

