/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.AbstractReplScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineCancellationException;
import org.eclipse.ease.ScriptExecutionException;
import org.eclipse.ease.ScriptObjectType;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.classloader.EaseClassLoader;
import org.eclipse.ease.debugging.EaseDebugFrame;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.debugging.model.EaseDebugVariable;
import org.eclipse.ease.lang.javascript.JavaScriptCodeFactory;
import org.eclipse.ease.lang.javascript.rhino.ObservingContextFactory;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.swt.widgets.Display;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.Debugger;

public class RhinoScriptEngine
extends AbstractReplScriptEngine {
    private static final EaseClassLoader CLASSLOADER = new EaseClassLoader();
    public static final String ENGINE_ID = "org.eclipse.ease.javascript.rhino";
    private ScriptableObject fScope;
    private Context fContext;
    private int fOptimizationLevel = 9;
    private ScriptStackTrace fExceptionStackTrace = null;

    static {
        ContextFactory.initGlobal((ContextFactory)new ObservingContextFactory());
        AccessController.doPrivileged(() -> {
            ContextFactory.getGlobal().initApplicationClassLoader((ClassLoader)CLASSLOADER);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            ContextFactory contextFactory = ContextFactory.getGlobal();
            synchronized (contextFactory) {
                context = Context.enter();
            }
        }
        return context;
    }

    private static boolean hasNoChildElements(Object scope) {
        if (scope instanceof Double) {
            return true;
        }
        return scope == null;
    }

    public RhinoScriptEngine() {
        super("Rhino");
    }

    protected RhinoScriptEngine(String name) {
        super(name);
    }

    public void setOptimizationLevel(int level) {
        this.fOptimizationLevel = level;
    }

    protected synchronized void setupEngine() {
        this.fContext = RhinoScriptEngine.getContext();
        this.fContext.setGeneratingDebug(false);
        this.fContext.setOptimizationLevel(this.fOptimizationLevel);
        this.fContext.setDebugger(null, null);
        this.fScope = new ImporterTopLevel(this.fContext);
        this.fContext.setGenerateObserverCount(true);
        this.fContext.setInstructionObserverThreshold(10);
        try {
            Context.class.getDeclaredField("VERSION_ES6");
            this.fContext.setLanguageVersion(200);
        }
        catch (Exception e) {
            try {
                Context.class.getDeclaredField("VERSION_1_8");
                this.fContext.setLanguageVersion(180);
            }
            catch (Exception e1) {
                this.fContext.setLanguageVersion(170);
            }
        }
    }

    protected synchronized void teardownEngine() {
        this.fContext.setDebugger(null, null);
        Context.exit();
        this.fContext = null;
        this.fScope = null;
        CLASSLOADER.unregisterEngine((Job)this);
        super.teardownEngine();
    }

    protected Object execute(final Script script, final String fileName, boolean uiThread) throws Throwable {
        if (uiThread) {
            RunnableWithResult<Object> runnable = new RunnableWithResult<Object>(){

                public Object runWithTry() throws Throwable {
                    RhinoScriptEngine.getContext().initStandardObjects(RhinoScriptEngine.this.fScope);
                    return RhinoScriptEngine.this.internalExecute(script, fileName);
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return runnable.getResultOrThrow();
        }
        return this.internalExecute(script, fileName);
    }

    private Object internalExecute(Script script, String fileName) throws Throwable {
        Object result;
        block36: {
            block35: {
                ((ObservingContextFactory)ContextFactory.getGlobal()).cancelTerminate(RhinoScriptEngine.getContext());
                try {
                    if (script.getCommand() instanceof NativeFunction) {
                        result = ((NativeFunction)script.getCommand()).call(RhinoScriptEngine.getContext(), (Scriptable)this.fScope, (Scriptable)this.fScope, ScriptRuntime.emptyArgs);
                    } else if (script.getCommand() instanceof org.mozilla.javascript.Script) {
                        result = ((org.mozilla.javascript.Script)script.getCommand()).exec(RhinoScriptEngine.getContext(), (Scriptable)this.fScope);
                    } else {
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (InputStreamReader codeReader = new InputStreamReader(script.getCodeStream());){
                            result = RhinoScriptEngine.getContext().evaluateReader((Scriptable)this.fScope, (Reader)codeReader, fileName, 1, null);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    if (result instanceof Undefined) {
                        return ScriptResult.VOID;
                    }
                    if (result != null) break block35;
                    return null;
                }
                catch (RhinoException e) {
                    this.fExceptionStackTrace = this.getStackTrace().clone();
                    if (this.fExceptionStackTrace.isEmpty() || script != null && !script.equals((Object)((IScriptDebugFrame)this.fExceptionStackTrace.get(0)).getScript())) {
                        this.fExceptionStackTrace.add(0, (Object)new EaseDebugFrame(script, e.lineNumber(), 1));
                    }
                    String message = e.getMessage();
                    String errorName = "Error";
                    Throwable cause = null;
                    if (e instanceof WrappedException) {
                        Throwable wrapped = ((WrappedException)e).getWrappedException();
                        if (wrapped instanceof ScriptExecutionException) {
                            throw wrapped;
                        }
                        if (wrapped != null) {
                            message = wrapped.getMessage();
                            errorName = "JavaError";
                            cause = wrapped;
                        }
                    } else if (e instanceof EcmaError) {
                        message = ((EcmaError)e).getErrorMessage();
                        errorName = ((EcmaError)e).getName();
                    } else if (e instanceof JavaScriptException) {
                        Object value = ((JavaScriptException)e).getValue();
                        if (value instanceof NativeJavaObject) {
                            Object unwrapped = ((NativeJavaObject)value).unwrap();
                            if (unwrapped instanceof Throwable) {
                                message = ((Throwable)unwrapped).getMessage();
                                errorName = "JavaError";
                                cause = (Throwable)unwrapped;
                            } else {
                                message = unwrapped != null ? unwrapped.toString() : null;
                                errorName = "ScriptException";
                            }
                        } else {
                            message = ((JavaScriptException)e).getValue() != null ? ((JavaScriptException)e).getValue().toString() : null;
                            errorName = "ScriptException";
                        }
                    } else if (e instanceof EvaluatorException) {
                        errorName = "SyntaxError";
                    } else {
                        message = "Error running script";
                    }
                    throw new ScriptExecutionException(message, e.columnNumber(), e.lineSource(), errorName, this.getExceptionStackTrace(), cause);
                }
            }
            if (result instanceof NativeJavaObject) {
                return ((NativeJavaObject)result).unwrap();
            }
            if (!"org.mozilla.javascript.InterpretedFunction".equals(result.getClass().getName())) break block36;
            return null;
        }
        return result;
    }

    public ScriptStackTrace getExceptionStackTrace() {
        return this.fExceptionStackTrace;
    }

    public void terminateCurrent() {
        if (Thread.currentThread().equals(this.getThread())) {
            throw new ScriptEngineCancellationException();
        }
        ((ObservingContextFactory)ContextFactory.getGlobal()).terminate(this.fContext);
    }

    public synchronized void registerJar(URL url) {
        CLASSLOADER.registerURL((Job)this, url);
    }

    protected Object internalGetVariable(String name) {
        return this.getVariable((Scriptable)this.fScope, name);
    }

    protected Map<String, Object> internalGetVariables() {
        return this.getVariables((Scriptable)this.fScope);
    }

    public Map<String, Object> getVariables(final Scriptable scope) {
        return this.runInJobContext(new RunnableWithResult<Map<String, Object>>(){

            public Map<String, Object> runWithTry() throws Throwable {
                TreeMap<String, Object> result = new TreeMap<String, Object>();
                Scriptable parent = scope.getParentScope();
                if (parent != null) {
                    result.putAll(RhinoScriptEngine.this.getVariables(parent));
                }
                RhinoScriptEngine.getContext();
                Object[] objectArray = scope.getIds();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object key = objectArray[n2];
                    Object value = RhinoScriptEngine.this.getVariable(scope, key.toString());
                    if (value == null || !value.getClass().getName().startsWith("org.mozilla.javascript.gen")) {
                        result.put(key.toString(), value);
                    }
                    ++n2;
                }
                return result;
            }
        });
    }

    private Object getVariable(final Scriptable scope, final String name) {
        return this.runInJobContext(new RunnableWithResult<Object>(){

            public Object runWithTry() throws Throwable {
                Object value = scope.get(name, scope);
                if (value instanceof NativeJavaObject) {
                    return ((NativeJavaObject)value).unwrap();
                }
                return value;
            }
        });
    }

    protected boolean internalHasVariable(final String name) {
        return this.runInJobContext(new RunnableWithResult<Boolean>(){

            public Boolean runWithTry() throws Throwable {
                Object value = RhinoScriptEngine.this.fScope.get(name, (Scriptable)RhinoScriptEngine.this.fScope);
                return !Scriptable.NOT_FOUND.equals(value);
            }
        });
    }

    private <T> T runInJobContext(RunnableWithResult<T> runnable) {
        if (Context.getCurrentContext() != null) {
            runnable.run();
            return (T)runnable.getResult();
        }
        RhinoScriptEngine.getContext();
        runnable.run();
        Context.exit();
        return (T)runnable.getResult();
    }

    protected void internalSetVariable(final String name, final Object content) {
        this.runInJobContext(new RunnableWithResult<Boolean>(){

            public Boolean runWithTry() throws Throwable {
                if (!JavaScriptCodeFactory.isSaveName((String)name)) {
                    throw new IllegalArgumentException(String.format("'%s' is not a valid JavaScript variable name", name));
                }
                ScriptableObject scope = RhinoScriptEngine.this.fScope;
                Object jsOut = RhinoScriptEngine.this.internaljavaToJS(content, (Scriptable)scope);
                scope.put(name, (Scriptable)scope, jsOut);
                return true;
            }
        });
    }

    protected Object internaljavaToJS(Object value, Scriptable scope) {
        if (this.isPrimitiveType(value) || value instanceof Scriptable) {
            return value;
        }
        if (value instanceof Character) {
            return String.valueOf(((Character)value).charValue());
        }
        return RhinoScriptEngine.getContext().getWrapFactory().wrap(RhinoScriptEngine.getContext(), scope, value, null);
    }

    private boolean isPrimitiveType(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean;
    }

    public ScriptableObject getScope() {
        return this.fScope;
    }

    protected Context getCurrentContext() {
        return this.fContext;
    }

    protected Collection<EaseDebugVariable> getDefinedVariables(Object scope) {
        HashSet<EaseDebugVariable> result = new HashSet<EaseDebugVariable>();
        if (scope instanceof ImporterTopLevel) {
            Object[] objectIDs;
            Object[] objectArray = objectIDs = ((ImporterTopLevel)scope).getIds();
            int n = objectIDs.length;
            int n2 = 0;
            while (n2 < n) {
                Object id = objectArray[n2];
                Object object = ((ImporterTopLevel)scope).get(id);
                if (this.acceptVariable(object)) {
                    EaseDebugVariable variable = this.createVariable(id.toString(), object);
                    result.add(variable);
                }
                ++n2;
            }
        } else if (scope instanceof NativeArray) {
            for (int indexId : RhinoScriptEngine.getArrayIndexIds((NativeArray)scope)) {
                EaseDebugVariable variable = this.createVariable("[" + indexId + "]", ((NativeArray)scope).get(indexId));
                result.add(variable);
            }
            Object[] objectArray = ((NativeArray)scope).getIds();
            int variable = objectArray.length;
            int n = 0;
            while (n < variable) {
                Object id = objectArray[n];
                if (!(id instanceof Integer)) {
                    EaseDebugVariable variable2 = this.createVariable(id.toString(), ((NativeArray)scope).get(id));
                    result.add(variable2);
                }
                ++n;
            }
        } else if (scope instanceof NativeObject) {
            for (Map.Entry<String, Object> entry : this.getNativeChildObjects((NativeObject)scope).entrySet()) {
                EaseDebugVariable variable = this.createVariable(entry.getKey(), entry.getValue());
                result.add(variable);
            }
        } else if (scope instanceof NativeJavaArray) {
            Object[] objectArray = ((NativeJavaArray)scope).getIds();
            int n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object id = objectArray[n3];
                if (id instanceof Integer) {
                    EaseDebugVariable variable = this.createVariable("[" + id + "]", ((NativeJavaArray)scope).get(((Integer)id).intValue(), (Scriptable)scope));
                    result.add(variable);
                }
                ++n3;
            }
        } else if (scope instanceof Scriptable) {
            Object[] objectArray = ((Scriptable)scope).getIds();
            int n = objectArray.length;
            int n4 = 0;
            while (n4 < n) {
                Object id = objectArray[n4];
                EaseDebugVariable variable = this.createVariable(id.toString(), ((Scriptable)scope).get(id.toString(), (Scriptable)scope));
                result.add(variable);
                ++n4;
            }
        } else {
            if (RhinoScriptEngine.hasNoChildElements(scope)) {
                return result;
            }
            return null;
        }
        return result;
    }

    private static List<Integer> getArrayIndexIds(NativeArray nativeArray) {
        Integer[] indexIds = nativeArray.getIndexIds();
        List<Integer> transformedIndexIds = indexIds instanceof List ? (List<Integer>)indexIds : (indexIds instanceof Integer[] ? Arrays.asList(indexIds) : Collections.emptyList());
        return transformedIndexIds;
    }

    protected EaseDebugVariable createVariable(String name, Object value) {
        EaseDebugVariable variable = super.createVariable(name, value);
        if (value instanceof NativeArray) {
            variable.getValue().setValueString("array[" + ((NativeArray)value).getIds().length + "]");
            variable.setType(EaseDebugVariable.Type.NATIVE_ARRAY);
        } else if (value instanceof NativeObject) {
            variable.getValue().setValueString("object{" + this.getNativeChildObjects((NativeObject)value).size() + "}");
            variable.setType(EaseDebugVariable.Type.NATIVE_OBJECT);
        } else if (value instanceof String) {
            try {
                if (this.hasVariable(name)) {
                    Debugger debugger = RhinoScriptEngine.getContext().getDebugger();
                    Object debuggerContextData = RhinoScriptEngine.getContext().getDebuggerContextData();
                    RhinoScriptEngine.getContext().setDebugger(null, null);
                    Object inject = this.inject(String.valueOf(name) + ".length;", false);
                    if (inject instanceof Integer) {
                        variable.setType(EaseDebugVariable.Type.NATIVE_OBJECT);
                    }
                    RhinoScriptEngine.getContext().setDebugger(debugger, debuggerContextData);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return variable;
    }

    private Map<String, Object> getNativeChildObjects(NativeObject parent) {
        HashMap<String, Object> childObjects = new HashMap<String, Object>();
        Object[] objectArray = parent.getIds();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            Object object = parent.get(id);
            if (this.acceptVariable(object)) {
                childObjects.put(id.toString(), object);
            }
            ++n2;
        }
        return childObjects;
    }

    protected boolean acceptVariable(Object value) {
        return value == null || !value.getClass().getName().startsWith("org.mozilla.javascript.gen") && !value.getClass().getName().startsWith("org.mozilla.javascript.Arguments");
    }

    public ScriptObjectType getType(Object object) {
        if (object != null) {
            if (object instanceof NativeArray) {
                return ScriptObjectType.NATIVE_ARRAY;
            }
            if (object instanceof NativeObject) {
                return ScriptObjectType.NATIVE_OBJECT;
            }
            if (object.getClass().getName().startsWith("org.mozilla.javascript")) {
                return ScriptObjectType.NATIVE;
            }
        }
        return super.getType(object);
    }

    public String toString(Object object) {
        if (object instanceof NativeArray) {
            ArrayList<Object> elements = new ArrayList<Object>();
            Integer[] integerArray = ((NativeArray)object).getIndexIds();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                int indexId = integerArray[n2];
                elements.add(((NativeArray)object).get(indexId));
                ++n2;
            }
            return this.buildArrayString(elements);
        }
        if (object instanceof NativeObject) {
            return this.buildObjectString(this.getNativeChildObjects((NativeObject)object));
        }
        if (this.getType(object) == ScriptObjectType.NATIVE) {
            return "{}";
        }
        return super.toString(object);
    }

    protected void notifyExecutionListeners(Script script, int status) {
        if (!this.getTerminateOnIdle() && 4 == status) {
            try {
                this.setVariable("_", script.getResult().get());
            }
            catch (ExecutionException e) {
                this.setVariable("_", e.getCause());
            }
        }
        super.notifyExecutionListeners(script, status);
    }
}

