/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module;

import javax.script.ScriptEngine;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenMappingGroup;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenRuntimeData;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;

public interface IAnalysisDataContainer {
    public static final int ERROR_QUARK = -2;

    public ITmfStateSystem getStateSystem();

    public DataDrivenMappingGroup getMappingGroup(String var1);

    default public boolean isReadOnlyContainer() {
        return true;
    }

    default public @Nullable TmfAttributePool getAttributePool(int startNodeQuark) {
        return null;
    }

    default public DataDrivenRuntimeData getExecutionData() {
        return DataDrivenRuntimeData.DEFAULT;
    }

    default public int getQuarkAbsoluteAndAdd(String ... path) {
        ITmfStateSystem stateSystem = this.getStateSystem();
        int quark = stateSystem.optQuarkAbsolute(path);
        if (quark == -2 && !this.isReadOnlyContainer() && stateSystem instanceof ITmfStateSystemBuilder) {
            quark = ((ITmfStateSystemBuilder)stateSystem).getQuarkAbsoluteAndAdd(path);
        }
        return quark;
    }

    default public int getQuarkRelativeAndAdd(int startNodeQuark, String ... path) {
        ITmfStateSystem stateSystem = this.getStateSystem();
        int quark = stateSystem.optQuarkRelative(startNodeQuark, path);
        if (quark == -2 && !this.isReadOnlyContainer() && stateSystem instanceof ITmfStateSystemBuilder) {
            quark = ((ITmfStateSystemBuilder)stateSystem).getQuarkRelativeAndAdd(startNodeQuark, path);
        }
        return quark;
    }

    default public void addFutureState(long time, @Nullable Object state, int quark, ITmfStateProvider.FutureEventType type) {
        throw new UnsupportedOperationException("Implementations should override this method");
    }

    default public void setScriptengine(String name, ScriptEngine engine) {
    }

    default public @Nullable ScriptEngine getScriptEngine(String name) {
        return null;
    }
}

