/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.projection;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.projection.IProjectionPosition;

public abstract class AbstractStructuredCommentFoldingPosition
extends Position
implements IProjectionPosition {
    public AbstractStructuredCommentFoldingPosition(int offset, int length) {
        super(offset, length);
    }

    public int computeCaptionOffset(IDocument document) throws BadLocationException {
        return this.findFirstContent(document.get(this.offset, this.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
        int foldEndOffset;
        int foldOffset;
        String content = document.get(this.offset, this.length);
        int contentStart = this.findFirstContent(content);
        int startLineNum = document.getLineOfOffset(this.getStartOffset());
        IRegion startLine = document.getLineInformation(startLineNum);
        int endLineNum = document.getLineOfOffset(this.getEndOffset()) + 1;
        IRegion endLine = document.getLineInformation(endLineNum);
        int captionLineNum = document.getLineOfOffset(this.getStartOffset() + contentStart);
        AbstractStructuredCommentFoldingPosition abstractStructuredCommentFoldingPosition = this;
        synchronized (abstractStructuredCommentFoldingPosition) {
            foldOffset = startLine.getOffset();
            if (foldOffset < this.offset) {
                this.offset = foldOffset;
            }
            if ((foldEndOffset = endLine.getOffset()) - this.offset > this.length) {
                this.length = foldEndOffset - this.offset;
            }
        }
        Region preRegion = null;
        Region postRegion = null;
        if (startLineNum < captionLineNum) {
            IRegion captionLine = document.getLineInformation(captionLineNum);
            preRegion = new Region(foldOffset, captionLine.getOffset() - foldOffset);
        }
        if (captionLineNum < endLineNum) {
            int postRegionOffset = document.getLineOffset(captionLineNum + 1);
            postRegion = new Region(postRegionOffset, foldEndOffset - postRegionOffset);
        }
        IRegion[] regions = null;
        if (preRegion != null && postRegion != null) {
            regions = new IRegion[]{preRegion, postRegion};
        } else if (preRegion != null) {
            regions = new IRegion[]{preRegion};
        } else if (postRegion != null) {
            regions = new IRegion[]{postRegion};
        }
        return regions;
    }

    private int findFirstContent(CharSequence content) {
        int lenght = content.length();
        int i = 0;
        while (i < lenght) {
            if (Character.isUnicodeIdentifierPart(content.charAt(i))) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected abstract int getStartOffset();

    protected abstract int getEndOffset();
}

