/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipEntry;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TarFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ZipFileSystemObject;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class FileSystemObjectImportStructureProvider
implements IImportStructureProvider {
    private IImportStructureProvider fImportProvider;
    private String fArchivePath;

    public FileSystemObjectImportStructureProvider(IImportStructureProvider importStructureProvider, String archivePath) {
        this.fImportProvider = importStructureProvider;
        this.fArchivePath = archivePath;
    }

    public List<IFileSystemObject> getChildren(Object element) {
        List children = this.fImportProvider.getChildren(((IFileSystemObject)element).getRawFileSystemObject());
        ArrayList<IFileSystemObject> adapted = new ArrayList<IFileSystemObject>(children.size());
        for (Object o : children) {
            adapted.add(this.getIFileSystemObject(o));
        }
        return adapted;
    }

    public IFileSystemObject getIFileSystemObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof File) {
            return new FileFileSystemObject((File)o);
        }
        if (o instanceof TarArchiveEntry) {
            return new TarFileSystemObject((TarArchiveEntry)o, this.fArchivePath);
        }
        if (o instanceof ZipArchiveEntry) {
            return new ZipFileSystemObject((ZipArchiveEntry)o, this.fArchivePath);
        }
        if (o instanceof GzipEntry) {
            return new GzipFileSystemObject((GzipEntry)o, this.fArchivePath);
        }
        throw new IllegalArgumentException("Object type not handled");
    }

    public InputStream getContents(Object fileSystemObject) {
        return this.fImportProvider.getContents(((IFileSystemObject)fileSystemObject).getRawFileSystemObject());
    }

    public String getFullPath(Object element) {
        return this.fImportProvider.getFullPath(((IFileSystemObject)element).getRawFileSystemObject());
    }

    public String getLabel(Object element) {
        return this.fImportProvider.getLabel(((IFileSystemObject)element).getRawFileSystemObject());
    }

    public boolean isFolder(Object element) {
        return this.fImportProvider.isFolder(((IFileSystemObject)element).getRawFileSystemObject());
    }

    public void dispose() {
    }
}

