/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.remote.core.IRemoteResource;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.eclipse.remote.internal.core.RemoteResourceFactory;
import org.eclipse.remote.internal.core.services.local.LocalResource;

public class RemoteResourceAdapterFactory
implements IAdapterFactory {
    public static final String EXTENSION_POINT_ID = "remoteResources";
    public static final String ATTR_NATURE = "nature";
    public static final String ATTR_CLASS = "class";
    private Map<String, RemoteResourceFactory> fResourceFactory;

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IRemoteResource.class && adaptableObject instanceof IResource) {
            this.loadExtensions();
            IResource resource = (IResource)adaptableObject;
            for (String nature : this.fResourceFactory.keySet()) {
                try {
                    RemoteResourceFactory factory;
                    if (!resource.getProject().hasNature(nature) || (factory = this.fResourceFactory.get(nature)) == null) continue;
                    return factory.getRemoteResource(resource);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return new LocalResource(resource);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IRemoteResource.class};
    }

    private synchronized void loadExtensions() {
        if (this.fResourceFactory == null) {
            this.fResourceFactory = new HashMap<String, RemoteResourceFactory>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(RemoteCorePlugin.getUniqueIdentifier(), EXTENSION_POINT_ID);
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    String nature = ce.getAttribute(ATTR_NATURE);
                    RemoteResourceFactory factory = new RemoteResourceFactory(ce);
                    this.fResourceFactory.put(nature, factory);
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

