/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph;

import com.google.common.collect.ImmutableMap;
import java.text.Format;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ICallStackSymbol;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.ICalledFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

public class FlamegraphEvent
extends TimeEvent {
    private final ICallStackSymbol fSymbol;
    private final AggregatedCallSite fCallSite;

    public FlamegraphEvent(ITimeGraphEntry source, long beginTime, AggregatedCallSite aggregatedFunction) {
        super(source, beginTime, aggregatedFunction.getWeight(), ((ICallStackSymbol)aggregatedFunction.getObject()).hashCode());
        this.fSymbol = (ICallStackSymbol)aggregatedFunction.getObject();
        this.fCallSite = aggregatedFunction;
    }

    public Object getSymbol() {
        return this.fSymbol;
    }

    public Map<String, String> getTooltip(Format formatter) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry entry : this.fCallSite.getStatistics().entrySet()) {
            String statType = String.valueOf(entry.getKey());
            IStatistics stats = (IStatistics)entry.getValue();
            if (stats.getMax() == -1L) continue;
            builder.put((Object)statType, (Object)"");
            String lowerType = statType.toLowerCase();
            builder.put((Object)("\t" + Messages.FlameGraph_Total + ' ' + lowerType), (Object)formatter.format(stats.getTotal()));
            builder.put((Object)("\t" + Messages.FlameGraph_Average + ' ' + lowerType), (Object)formatter.format(stats.getMean()));
            builder.put((Object)("\t" + Messages.FlameGraph_Max + ' ' + lowerType), (Object)formatter.format(stats.getMax()));
            builder.put((Object)("\t" + Messages.FlameGraph_Min + ' ' + lowerType), (Object)formatter.format(stats.getMin()));
            builder.put((Object)("\t" + Messages.FlameGraph_Deviation + ' ' + lowerType), (Object)formatter.format(stats.getStdDev()));
        }
        return builder.build();
    }

    public long getNumberOfCalls() {
        AggregatedCallSite callSite = this.fCallSite;
        if (callSite instanceof AggregatedCalledFunction) {
            return ((AggregatedCalledFunction)callSite).getNbCalls();
        }
        return callSite.getWeight();
    }

    public @Nullable ICalledFunction getMinObject() {
        AggregatedCallSite callSite = this.fCallSite;
        if (callSite instanceof AggregatedCalledFunction) {
            return (ICalledFunction)((AggregatedCalledFunction)callSite).getFunctionStatistics().getDurationStatistics().getMinObject();
        }
        return null;
    }

    public @Nullable ICalledFunction getMaxObject() {
        AggregatedCallSite callSite = this.fCallSite;
        if (callSite instanceof AggregatedCalledFunction) {
            return (ICalledFunction)((AggregatedCalledFunction)callSite).getFunctionStatistics().getDurationStatistics().getMaxObject();
        }
        return null;
    }
}

