/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class Denormalize
implements CompilerPass,
NodeTraversal.Callback {
    private final AbstractCompiler compiler;

    Denormalize(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        this.maybeCollapseIntoForStatements(n, parent);
    }

    private void maybeCollapseIntoForStatements(Node n, Node parent) {
        if (parent == null || !NodeUtil.isStatementBlock(parent)) {
            return;
        }
        if (!n.isExprResult() && !n.isVar()) {
            return;
        }
        Node nextSibling = n.getNext();
        if (nextSibling == null) {
            return;
        }
        if (NodeUtil.isForIn(nextSibling)) {
            Node name;
            Node forNode = nextSibling;
            Node forVar = forNode.getFirstChild();
            if (forVar.isName() && n.isVar() && n.hasOneChild() && !(name = n.getFirstChild()).hasChildren() && forVar.getString().equals(name.getString())) {
                parent.removeChild(n);
                forNode.replaceChild(forVar, n);
                this.compiler.reportCodeChange();
            }
        } else if (nextSibling.isFor() && nextSibling.getFirstChild().isEmpty()) {
            Node newInitializer;
            if (NodeUtil.containsType(n, 51)) {
                return;
            }
            Node forNode = nextSibling;
            Node oldInitializer = forNode.getFirstChild();
            parent.removeChild(n);
            if (n.isVar()) {
                newInitializer = n;
            } else {
                Preconditions.checkState((boolean)n.hasOneChild(), (Object)n);
                newInitializer = n.getFirstChild();
                n.removeChild(newInitializer);
            }
            forNode.replaceChild(oldInitializer, newInitializer);
            this.compiler.reportCodeChange();
        }
    }
}

