/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;

public class DelegatingJarClassLoader
extends ClassLoader {
    private URLClassLoader fURLClassLoader = null;

    public DelegatingJarClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.fURLClassLoader != null) {
            try {
                return this.fURLClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.loadClass(name);
    }

    public void registerURL(URL url) {
        if (this.fURLClassLoader == null) {
            this.fURLClassLoader = URLClassLoader.newInstance(new URL[]{url});
        } else {
            URL[] registeredURLs = this.fURLClassLoader.getURLs();
            List<URL> urlList = Arrays.asList(registeredURLs);
            if (!urlList.contains(url)) {
                URL[] updatedURLs = Arrays.copyOf(registeredURLs, registeredURLs.length + 1);
                updatedURLs[updatedURLs.length - 1] = url;
                this.fURLClassLoader = URLClassLoader.newInstance(updatedURLs);
            }
        }
    }
}

