/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class CombinedSourceTypeBinding
extends SourceTypeBinding {
    SourceTypeBinding[] sourceTypes = new SourceTypeBinding[2];

    public CombinedSourceTypeBinding(Scope scope, SourceTypeBinding initialSourceType, SourceTypeBinding initialSourceType2) {
        super(initialSourceType.compoundName, initialSourceType.fPackage, scope);
        this.sourceTypes[0] = initialSourceType;
        this.sourceTypes[1] = initialSourceType2;
        this.setSuperclass(initialSourceType);
        this.setSuperclass(initialSourceType2);
        this.tagBits |= initialSourceType.tagBits;
        this.tagBits |= initialSourceType2.tagBits;
    }

    public void addSourceType(SourceTypeBinding binding) {
        int length = this.sourceTypes.length;
        this.sourceTypes = new SourceTypeBinding[length + 1];
        System.arraycopy(this.sourceTypes, 0, this.sourceTypes, 0, length);
        this.sourceTypes[length] = binding;
        this.setSuperclass(binding);
        this.tagBits |= binding.tagBits;
    }

    @Override
    public FieldBinding[] fields() {
        ArrayList<FieldBinding> list = new ArrayList<FieldBinding>();
        int i = 0;
        while (i < this.sourceTypes.length) {
            FieldBinding[] bindings = this.sourceTypes[i].fields();
            list.addAll(Arrays.asList(bindings));
            ++i;
        }
        return list.toArray(new FieldBinding[list.size()]);
    }

    @Override
    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        MethodBinding methodBinding = null;
        int i = 0;
        while (i < this.sourceTypes.length && methodBinding == null) {
            methodBinding = this.sourceTypes[i].getExactMethod(selector, argumentTypes, refScope);
            ++i;
        }
        return methodBinding;
    }

    @Override
    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        FieldBinding fieldBinding = null;
        int i = 0;
        while (i < this.sourceTypes.length && fieldBinding == null) {
            fieldBinding = this.sourceTypes[i].getField(fieldName, needResolve);
            ++i;
        }
        return fieldBinding;
    }

    @Override
    public InferredType getInferredType() {
        throw new UnimplementedException("should not get here");
    }

    @Override
    public MethodBinding[] getMethods(char[] selector) {
        ArrayList<MethodBinding> list = new ArrayList<MethodBinding>();
        int i = 0;
        while (i < this.sourceTypes.length) {
            MethodBinding[] bindings = this.sourceTypes[i].getMethods(selector);
            list.addAll(Arrays.asList(bindings));
            ++i;
        }
        return list.toArray(new MethodBinding[list.size()]);
    }

    @Override
    public boolean hasMemberTypes() {
        int i = 0;
        while (i < this.sourceTypes.length) {
            if (this.sourceTypes[i].hasMemberTypes()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isEquivalentTo(TypeBinding otherType) {
        return this == otherType;
    }

    @Override
    public ReferenceBinding[] memberTypes() {
        ArrayList<ReferenceBinding> list = new ArrayList<ReferenceBinding>();
        int i = 0;
        while (i < this.sourceTypes.length) {
            ReferenceBinding[] bindings = this.sourceTypes[i].memberTypes();
            list.addAll(Arrays.asList(bindings));
            ++i;
        }
        return list.toArray(new ReferenceBinding[list.size()]);
    }

    @Override
    public MethodBinding[] methods() {
        ArrayList<MethodBinding> list = new ArrayList<MethodBinding>();
        int i = 0;
        while (i < this.sourceTypes.length) {
            MethodBinding[] bindings = this.sourceTypes[i].methods();
            list.addAll(Arrays.asList(bindings));
            ++i;
        }
        return list.toArray(new MethodBinding[list.size()]);
    }

    @Override
    public void setFields(FieldBinding[] fields) {
        throw new UnimplementedException("should not get here");
    }

    @Override
    public void setMethods(MethodBinding[] methods) {
        throw new UnimplementedException("should not get here");
    }

    @Override
    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        int i = 0;
        while (i < this.sourceTypes.length) {
            MethodBinding exactConstructor = this.sourceTypes[i].getExactConstructor(argumentTypes);
            if (exactConstructor != null && exactConstructor.isValidBinding()) {
                return exactConstructor;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isLinkedType(ReferenceBinding binding) {
        int i = 0;
        while (i < this.sourceTypes.length) {
            if (this.sourceTypes[i] == binding) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        int i = 0;
        while (i < this.sourceTypes.length) {
            this.sourceTypes[i].cleanup();
            ++i;
        }
    }

    private void setSuperclass(SourceTypeBinding from) {
        if (this.getSuperBinding0() == null || from.getSuperBinding0() != null && from.getSuperBinding0().id != 1) {
            this.setSuperBinding(from.getSuperBinding0());
        }
    }

    @Override
    public ReferenceBinding getSuperBinding() {
        ReferenceBinding supercls = null;
        int i = 0;
        while (i < this.sourceTypes.length) {
            supercls = this.sourceTypes[i].getSuperBinding0();
            if (supercls != null && supercls.id != 1) {
                return supercls;
            }
            ++i;
        }
        if (supercls != null && this.getSuperBinding0() == null) {
            return supercls;
        }
        return this.getSuperBinding0();
    }
}

