/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.ui.AnalysisUtil;
import org.eclipse.trace4cps.ui.dialog.ResourceClientHistogramDialog;
import org.eclipse.trace4cps.ui.view.ChartView;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;

public class ResourceHistogramAction
extends AbstractTraceViewAction {
    public ResourceHistogramAction(TraceView view) {
        super(view);
        this.setText("Resource-usage histogram");
    }

    public boolean isEnabled() {
        return this.view.getNumTraces() == 1 && this.view.hasClaims(true);
    }

    @Override
    protected void doRun() throws TraceException {
        ResourceClientHistogramDialog dialog = new ResourceClientHistogramDialog(this.view.getEditorSite().getShell(), this.view.getTrace().getResources(), true);
        if (dialog.open() == 1) {
            return;
        }
        JFreeChart chart = AnalysisUtil.createResourceUsageHistogramPlot(this.view.getTrace(), dialog.getSelected(), this.viewCfg.getDescribingAttributes(TracePart.RESOURCE), dialog.cumulative());
        ChartFactory.getChartTheme().apply(chart);
        ChartView.showChart(chart, "Resource-usage histogram", "Resource-usage histogram");
    }
}

