/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.trace4cps.analysis.dist.DependencyInclusionCheck;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.ui.ConsoleUtil;
import org.eclipse.trace4cps.ui.dialog.DependencyAnalysisWizard;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;

public class DependencyAction
extends AbstractTraceViewAction {
    public DependencyAction(TraceView view) {
        super(view);
        this.setText("Dependency analysis");
    }

    public boolean isEnabled() {
        return this.view.getNumTraces() == 2;
    }

    @Override
    protected void doRun() throws TraceException {
        DependencyAnalysisWizard wizard = new DependencyAnalysisWizard(this.view);
        if (new WizardDialog(this.view.getEditorSite().getShell(), (IWizard)wizard).open() == 1) {
            return;
        }
        int modelTraceIdx = wizard.getModelTraceIdx();
        int systemTraceIdx = wizard.getSystemTraceIdx();
        ITrace modelTrace = this.view.getTrace(modelTraceIdx);
        ITrace systemTrace = this.view.getTrace(systemTraceIdx);
        String weightAttribute = wizard.getWeightAttribute();
        List deps = DependencyInclusionCheck.check((ITrace)modelTrace, (ITrace)systemTrace, (String)weightAttribute);
        ConsoleUtil.log("Unsatisfied dependencies of " + TraceHelper.getValues((IAttributeAware)modelTrace, (boolean)false) + " in " + TraceHelper.getValues((IAttributeAware)systemTrace, (boolean)false) + " : " + deps.size());
        for (IDependency d : deps) {
            d.setAttribute("analysis_type", ((Object)((Object)this)).getClass().getName());
        }
        this.view.addDependencyExtension(deps, systemTraceIdx);
        this.view.update();
    }
}

