/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public class ScopeStack {
    public final @Nullable ScopeStack parent;
    public final String scopeName;

    static @Nullable ScopeStack push(@Nullable ScopeStack path, List<String> scopeNames) {
        for (String name : scopeNames) {
            path = new ScopeStack(path, name);
        }
        return path;
    }

    public static ScopeStack from(String first) {
        return new ScopeStack(null, first);
    }

    public static @Nullable ScopeStack from(String ... segments) {
        ScopeStack result = null;
        int i = 0;
        while (i < segments.length) {
            result = new ScopeStack(result, segments[i]);
            ++i;
        }
        return result;
    }

    public static @Nullable ScopeStack from(List<String> segments) {
        ScopeStack result = null;
        int i = 0;
        while (i < segments.size()) {
            result = new ScopeStack(result, segments.get(i));
            ++i;
        }
        return result;
    }

    public ScopeStack(@Nullable ScopeStack parent, String scopeName) {
        this.parent = parent;
        this.scopeName = scopeName;
    }

    public ScopeStack push(String scopeName) {
        return new ScopeStack(this, scopeName);
    }

    public List<String> getSegments() {
        @Nullable ScopeStack item = this;
        ArrayList<String> result = new ArrayList<String>();
        while (item != null) {
            result.add(item.scopeName);
            item = item.parent;
        }
        Collections.reverse(result);
        return result;
    }

    public String toString() {
        return String.join((CharSequence)" ", this.getSegments());
    }

    public boolean isExtending(ScopeStack other) {
        if (this == other) {
            return true;
        }
        ScopeStack parent = this.parent;
        if (parent == null) {
            return false;
        }
        return parent.isExtending(other);
    }

    public List<String> getExtensionIfDefined(@Nullable ScopeStack base) {
        ArrayList<String> result = new ArrayList<String>();
        @Nullable ScopeStack item = this;
        while (item != null && item != base) {
            result.add(item.scopeName);
            item = item.parent;
        }
        if (item == base) {
            Collections.reverse(result);
            return result;
        }
        return Collections.emptyList();
    }
}

