/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IStateStack;
import org.eclipse.tm4e.core.internal.grammar.StateStack;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.eclipse.tm4e.core.model.TMModel;
import org.eclipse.tm4e.core.model.TMToken;

public abstract class AbstractModelLines {
    private final List<ModelLine> list = new LinkedList<ModelLine>();
    private @Nullable TMModel model;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setModel(@Nullable TMModel model) {
        this.model = model;
        List<ModelLine> list = this.list;
        synchronized (list) {
            this.list.forEach(line -> {
                boolean bl = line.isInvalid = true;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLines(int lineIndex, int count) {
        if (count < 1) {
            return;
        }
        List<ModelLine> list = this.list;
        synchronized (list) {
            ModelLine firstLine = this.getOrNull(lineIndex);
            int i = 0;
            while (i < count) {
                this.list.add(lineIndex, new ModelLine());
                ++i;
            }
            if (firstLine != null) {
                this.list.get((int)lineIndex).startState = firstLine.startState;
            }
            this.updateLine(lineIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLines(int lineIndex, int count) {
        if (count < 1) {
            return;
        }
        List<ModelLine> list = this.list;
        synchronized (list) {
            count = Math.min(count, this.getNumberOfLines() - lineIndex);
            int i = 0;
            while (i < count) {
                this.list.remove(lineIndex);
                ++i;
            }
            this.updateLine(lineIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceLines(int lineIndex, int linesRemoved, int linesAdded) {
        if (linesRemoved == 0 && linesAdded == 0) {
            return;
        }
        if (linesRemoved == 1 && linesAdded == 1) {
            this.updateLine(lineIndex);
            return;
        }
        List<ModelLine> list = this.list;
        synchronized (list) {
            ModelLine firstLine = this.getOrNull(lineIndex);
            linesRemoved = Math.min(linesRemoved, this.getNumberOfLines() - lineIndex);
            int i = 0;
            while (i < linesRemoved) {
                this.list.remove(lineIndex);
                ++i;
            }
            i = 0;
            while (i < linesAdded) {
                this.list.add(lineIndex, new ModelLine());
                ++i;
            }
            if (firstLine != null) {
                this.list.get((int)lineIndex).startState = firstLine.startState;
            }
            this.updateLine(lineIndex);
        }
    }

    protected void updateLine(int lineIndex) {
        if (this.model != null) {
            this.model.invalidateLine(lineIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModelLine get(int lineIndex) {
        List<ModelLine> list = this.list;
        synchronized (list) {
            return this.list.get(lineIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable ModelLine getOrNull(int lineIndex) {
        List<ModelLine> list = this.list;
        synchronized (list) {
            if (lineIndex > -1 && lineIndex < this.list.size()) {
                return this.list.get(lineIndex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfLines() {
        List<ModelLine> list = this.list;
        synchronized (list) {
            return this.list.size();
        }
    }

    public abstract String getLineText(int var1) throws Exception;

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<ModelLine> list = this.list;
        synchronized (list) {
            return StringUtils.toString(this, sb -> {
                if (!this.list.isEmpty()) {
                    int i = 0;
                    while (i < this.list.size()) {
                        sb.append(i).append(": isInvalid=").append(this.list.get((int)i).isInvalid).append(", ");
                        ++i;
                    }
                    sb.setLength(sb.length() - 2);
                }
            });
        }
    }

    static final class ModelLine {
        volatile boolean isInvalid = true;
        IStateStack startState = StateStack.NULL;
        List<TMToken> tokens = Collections.emptyList();

        ModelLine() {
        }
    }
}

