/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar.dependencies;

public class IncludeReference {
    public static final IncludeReference BASE = new IncludeReference(Kind.Base, "$base", "");
    public static final IncludeReference SELF = new IncludeReference(Kind.Base, "$self", "");
    public final Kind kind;
    public final String scopeName;
    public final String ruleName;

    public static IncludeReference parseInclude(String include) {
        switch (include) {
            case "$base": {
                return BASE;
            }
            case "$self": {
                return SELF;
            }
        }
        int indexOfSharp = include.indexOf("#");
        switch (indexOfSharp) {
            case -1: {
                return new IncludeReference(Kind.TopLevelReference, include, "");
            }
            case 0: {
                return new IncludeReference(Kind.RelativeReference, "", include.substring(1));
            }
        }
        String scopeName = include.substring(0, indexOfSharp);
        String ruleName = include.substring(indexOfSharp + 1);
        return new IncludeReference(Kind.TopLevelRepositoryReference, scopeName, ruleName);
    }

    private IncludeReference(Kind kind, String scopeName, String ruleName) {
        this.kind = kind;
        this.scopeName = scopeName;
        this.ruleName = ruleName;
    }

    public static enum Kind {
        Base,
        Self,
        RelativeReference,
        TopLevelReference,
        TopLevelRepositoryReference;

    }
}

